/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datadog.jmxfetch.ExitWatcher;
import org.datadog.jmxfetch.Status;
import org.datadog.jmxfetch.converter.ExitWatcherConverter;
import org.datadog.jmxfetch.converter.ReporterConverter;
import org.datadog.jmxfetch.reporter.ConsoleReporter;
import org.datadog.jmxfetch.reporter.JsonReporter;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.validator.Log4JLevelValidator;
import org.datadog.jmxfetch.validator.PositiveIntegerValidator;
import org.datadog.jmxfetch.validator.ReporterValidator;

@Parameters(separators="=")
public class AppConfig {
    public static final String ACTION_COLLECT = "collect";
    public static final String ACTION_LIST_JVMS = "list_jvms";
    public static final String ACTION_LIST_EVERYTHING = "list_everything";
    public static final String ACTION_LIST_COLLECTED = "list_collected_attributes";
    public static final String ACTION_LIST_MATCHING = "list_matching_attributes";
    public static final String ACTION_LIST_WITH_METRICS = "list_with_metrics";
    public static final String ACTION_LIST_WITH_RATE_METRICS = "list_with_rate_metrics";
    public static final String ACTION_LIST_NOT_MATCHING = "list_not_matching_attributes";
    public static final String ACTION_LIST_LIMITED = "list_limited_attributes";
    public static final String ACTION_HELP = "help";
    public static final String ACTION_VERSION = "version";
    public static final HashSet<String> ACTIONS = new HashSet<String>(Arrays.asList("collect", "list_everything", "list_collected_attributes", "list_matching_attributes", "list_with_metrics", "list_with_rate_metrics", "list_not_matching_attributes", "list_limited_attributes", "help", "version", "list_jvms"));
    private static final String AD_WIN_PIPE_PATH = "\\\\.\\pipe\\";
    private static final String AD_PIPE_NAME = "dd-auto_discovery";
    private static final String AD_LAUNCH_FILE = "jmx.launch";
    private static final int DEFAULT_THREAD_POOL_SIZE = 3;
    private static final int DEFAULT_COLLECTION_TO_S = 60;
    private static final int DEFAULT_RECONNECTION_TO_S = 60;
    @Parameter(names={"--help", "-h"}, description="Display this help page", help=true)
    private boolean help;
    @Parameter(names={"--version", "-v"}, description="Display the version number and exit", help=true)
    private boolean version;
    @Parameter(names={"--log_level", "-L"}, description="Level of verbosity", validateWith=Log4JLevelValidator.class, required=false)
    private String logLevel;
    @Parameter(names={"--log_location", "-l"}, description="Absolute path of the log file (default to null = no logging)", required=false)
    private String logLocation;
    @Parameter(names={"--log_format_rfc3339"}, description="Logs using the RFC3339 format for dates", required=false)
    private boolean logFormatRfc3339;
    @Parameter(names={"--conf_directory", "-D"}, description="Absolute path to the conf.d directory", required=false)
    private String confdDirectory;
    @Parameter(names={"--tmp_directory", "-T"}, description="Absolute path to a temporary directory", required=false)
    private String tmpDirectory;
    @Parameter(names={"--reporter", "-r"}, description="Reporter to use: should be either \"statsd:[STATSD_PORT]\", \"console\" or \"json\"", validateWith=ReporterValidator.class, converter=ReporterConverter.class, required=false)
    private Reporter reporter;
    @Parameter(names={"--check", "-c"}, description="Yaml file name to read (must be in the confd directory)", required=false, variableArity=true)
    private List<String> yamlFileList;
    @Parameter(names={"--check_period", "-p"}, description="Sleeping time during two iterations in ms", validateWith=PositiveIntegerValidator.class, required=false)
    private int checkPeriod;
    @Parameter(names={"--thread_pool_size", "-t"}, description="The size of the thread pool", validateWith=PositiveIntegerValidator.class, required=false)
    private int threadPoolSize;
    @Parameter(names={"--reconnection_thread_pool_size", "-u"}, description="The size of the reconnection thread pool", validateWith=PositiveIntegerValidator.class, required=false)
    private int reconnectionThreadPoolSize;
    @Parameter(names={"--collection_timeout", "-x"}, description="The concurrent collection timeout in seconds", validateWith=PositiveIntegerValidator.class, required=false)
    private int collectionTimeout;
    @Parameter(names={"--reconnection_timeout", "-y"}, description="The reconnection timeout in seconds", validateWith=PositiveIntegerValidator.class, required=false)
    private int reconnectionTimeout;
    @Parameter(names={"--ad_enabled", "--sd_enabled", "-w"}, description="Enable Auto Discovery.", required=false)
    private boolean adEnabled;
    @Parameter(names={"--ad_pipe", "--sd_pipe", "-P"}, description="Auto Discovery pipe name.", required=false)
    private String adPipe;
    @Parameter(names={"--status_location", "-s"}, description="Absolute path of the status file. (default to null = no status file written)", required=false)
    private String statusLocation;
    @Parameter(names={"--exit_file_location", "-e"}, description="Absolute path of the trigger file to watch to exit. (default to null = no exit on file)", converter=ExitWatcherConverter.class, required=false)
    private ExitWatcher exitWatcher;
    @Parameter(description="Action to take, should be in [help, version, collect, list_everything, list_collected_attributes, list_matching_attributes, list_with_metrics, list_with_rate_metrics, list_not_matching_attributes, list_limited_attributes, list_jvms]", required=true)
    private List<String> action;
    @Parameter(names={"--ipc_host", "-H"}, description="IPC host", required=false)
    private String ipcHost;
    @Parameter(names={"--ipc_port", "-I"}, description="IPC port", validateWith=PositiveIntegerValidator.class, required=false)
    private int ipcPort;
    private boolean targetDirectInstances;
    private boolean daemon;
    private boolean embedded;
    private List<String> instanceConfigResources;
    private List<String> metricConfigResources;
    private List<String> metricConfigFiles;
    private Integer refreshBeansPeriod;
    private Map<String, String> globalTags;
    private Status status;

    public boolean updateStatus() {
        if (this.statusLocation != null) {
            this.status = new Status(this.statusLocation);
            return true;
        }
        if (this.ipcHost != null && this.ipcPort > 0) {
            this.status = new Status(this.ipcHost, this.ipcPort);
            return true;
        }
        return false;
    }

    public boolean remoteEnabled() {
        return this.ipcHost != null && this.ipcPort > 0;
    }

    public String getStatusLocation() {
        return this.statusLocation;
    }

    public String getAction() {
        if (this.action == null || this.action.isEmpty()) {
            return null;
        }
        return this.action.get(0);
    }

    public boolean isConsoleReporter() {
        return this.reporter != null && this.reporter instanceof ConsoleReporter;
    }

    public boolean isJsonReporter() {
        return this.reporter != null && this.reporter instanceof JsonReporter;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public Status getStatus() {
        return this.status;
    }

    public ExitWatcher getExitWatcher() {
        return this.exitWatcher;
    }

    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getReconnectionThreadPoolSize() {
        return this.reconnectionThreadPoolSize;
    }

    public int getCollectionTimeout() {
        return this.collectionTimeout;
    }

    public int getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public String getIpcHost() {
        return this.ipcHost;
    }

    public int getIpcPort() {
        return this.ipcPort;
    }

    public boolean getAutoDiscoveryPipeEnabled() {
        return this.adEnabled;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public List<String> getYamlFileList() {
        return this.yamlFileList;
    }

    public String getConfdDirectory() {
        return this.confdDirectory;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public boolean isLogFormatRfc3339() {
        return this.logFormatRfc3339;
    }

    public String getAutoDiscoveryPipe() {
        String pipePath = System.getProperty("os.name").startsWith("Windows") ? "\\\\.\\pipe\\/" + this.adPipe : this.getTmpDirectory() + "/" + this.adPipe;
        return pipePath;
    }

    public String getJmxLaunchFile() {
        return this.getTmpDirectory() + "/" + AD_LAUNCH_FILE;
    }

    public boolean isTargetDirectInstances() {
        return this.targetDirectInstances;
    }

    public List<String> getInstanceConfigResources() {
        return this.instanceConfigResources;
    }

    public List<String> getMetricConfigResources() {
        return this.metricConfigResources;
    }

    public List<String> getMetricConfigFiles() {
        return this.metricConfigFiles;
    }

    public Integer getRefreshBeansPeriod() {
        return this.refreshBeansPeriod;
    }

    public Map<String, String> getGlobalTags() {
        return this.globalTags;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    private static String $default$logLevel() {
        return "INFO";
    }

    private static boolean $default$logFormatRfc3339() {
        return false;
    }

    private static String $default$tmpDirectory() {
        return "/tmp";
    }

    private static int $default$checkPeriod() {
        return 15000;
    }

    private static int $default$threadPoolSize() {
        return 3;
    }

    private static int $default$reconnectionThreadPoolSize() {
        return 3;
    }

    private static int $default$collectionTimeout() {
        return 60;
    }

    private static int $default$reconnectionTimeout() {
        return 60;
    }

    private static boolean $default$adEnabled() {
        return false;
    }

    private static String $default$adPipe() {
        return AD_PIPE_NAME;
    }

    private static ExitWatcher $default$exitWatcher() {
        return new ExitWatcher();
    }

    private static int $default$ipcPort() {
        return 0;
    }

    private static boolean $default$targetDirectInstances() {
        return false;
    }

    private static boolean $default$daemon() {
        return false;
    }

    private static boolean $default$embedded() {
        return false;
    }

    private static Status $default$status() {
        return new Status();
    }

    AppConfig(boolean help, boolean version, String logLevel, String logLocation, boolean logFormatRfc3339, String confdDirectory, String tmpDirectory, Reporter reporter, List<String> yamlFileList, int checkPeriod, int threadPoolSize, int reconnectionThreadPoolSize, int collectionTimeout, int reconnectionTimeout, boolean adEnabled, String adPipe, String statusLocation, ExitWatcher exitWatcher, List<String> action, String ipcHost, int ipcPort, boolean targetDirectInstances, boolean daemon, boolean embedded, List<String> instanceConfigResources, List<String> metricConfigResources, List<String> metricConfigFiles, Integer refreshBeansPeriod, Map<String, String> globalTags, Status status) {
        this.help = help;
        this.version = version;
        this.logLevel = logLevel;
        this.logLocation = logLocation;
        this.logFormatRfc3339 = logFormatRfc3339;
        this.confdDirectory = confdDirectory;
        this.tmpDirectory = tmpDirectory;
        this.reporter = reporter;
        this.yamlFileList = yamlFileList;
        this.checkPeriod = checkPeriod;
        this.threadPoolSize = threadPoolSize;
        this.reconnectionThreadPoolSize = reconnectionThreadPoolSize;
        this.collectionTimeout = collectionTimeout;
        this.reconnectionTimeout = reconnectionTimeout;
        this.adEnabled = adEnabled;
        this.adPipe = adPipe;
        this.statusLocation = statusLocation;
        this.exitWatcher = exitWatcher;
        this.action = action;
        this.ipcHost = ipcHost;
        this.ipcPort = ipcPort;
        this.targetDirectInstances = targetDirectInstances;
        this.daemon = daemon;
        this.embedded = embedded;
        this.instanceConfigResources = instanceConfigResources;
        this.metricConfigResources = metricConfigResources;
        this.metricConfigFiles = metricConfigFiles;
        this.refreshBeansPeriod = refreshBeansPeriod;
        this.globalTags = globalTags;
        this.status = status;
    }

    public static AppConfigBuilder builder() {
        return new AppConfigBuilder();
    }

    public String toString() {
        return "AppConfig(help=" + this.isHelp() + ", version=" + this.isVersion() + ", logLevel=" + this.getLogLevel() + ", logLocation=" + this.getLogLocation() + ", logFormatRfc3339=" + this.isLogFormatRfc3339() + ", confdDirectory=" + this.getConfdDirectory() + ", tmpDirectory=" + this.getTmpDirectory() + ", reporter=" + this.getReporter() + ", yamlFileList=" + this.getYamlFileList() + ", checkPeriod=" + this.getCheckPeriod() + ", threadPoolSize=" + this.getThreadPoolSize() + ", reconnectionThreadPoolSize=" + this.getReconnectionThreadPoolSize() + ", collectionTimeout=" + this.getCollectionTimeout() + ", reconnectionTimeout=" + this.getReconnectionTimeout() + ", adEnabled=" + this.adEnabled + ", adPipe=" + this.adPipe + ", statusLocation=" + this.getStatusLocation() + ", exitWatcher=" + this.getExitWatcher() + ", action=" + this.getAction() + ", ipcHost=" + this.getIpcHost() + ", ipcPort=" + this.getIpcPort() + ", targetDirectInstances=" + this.isTargetDirectInstances() + ", daemon=" + this.isDaemon() + ", embedded=" + this.isEmbedded() + ", instanceConfigResources=" + this.getInstanceConfigResources() + ", metricConfigResources=" + this.getMetricConfigResources() + ", metricConfigFiles=" + this.getMetricConfigFiles() + ", refreshBeansPeriod=" + this.getRefreshBeansPeriod() + ", globalTags=" + this.getGlobalTags() + ", status=" + this.getStatus() + ")";
    }

    public static class AppConfigBuilder {
        private boolean help;
        private boolean version;
        private boolean logLevel$set;
        private String logLevel;
        private String logLocation;
        private boolean logFormatRfc3339$set;
        private boolean logFormatRfc3339;
        private String confdDirectory;
        private boolean tmpDirectory$set;
        private String tmpDirectory;
        private Reporter reporter;
        private List<String> yamlFileList;
        private boolean checkPeriod$set;
        private int checkPeriod;
        private boolean threadPoolSize$set;
        private int threadPoolSize;
        private boolean reconnectionThreadPoolSize$set;
        private int reconnectionThreadPoolSize;
        private boolean collectionTimeout$set;
        private int collectionTimeout;
        private boolean reconnectionTimeout$set;
        private int reconnectionTimeout;
        private boolean adEnabled$set;
        private boolean adEnabled;
        private boolean adPipe$set;
        private String adPipe;
        private String statusLocation;
        private boolean exitWatcher$set;
        private ExitWatcher exitWatcher;
        private List<String> action;
        private String ipcHost;
        private boolean ipcPort$set;
        private int ipcPort;
        private boolean targetDirectInstances$set;
        private boolean targetDirectInstances;
        private boolean daemon$set;
        private boolean daemon;
        private boolean embedded$set;
        private boolean embedded;
        private List<String> instanceConfigResources;
        private List<String> metricConfigResources;
        private List<String> metricConfigFiles;
        private Integer refreshBeansPeriod;
        private Map<String, String> globalTags;
        private boolean status$set;
        private Status status;

        AppConfigBuilder() {
        }

        public AppConfigBuilder help(boolean help) {
            this.help = help;
            return this;
        }

        public AppConfigBuilder version(boolean version) {
            this.version = version;
            return this;
        }

        public AppConfigBuilder logLevel(String logLevel) {
            this.logLevel = logLevel;
            this.logLevel$set = true;
            return this;
        }

        public AppConfigBuilder logLocation(String logLocation) {
            this.logLocation = logLocation;
            return this;
        }

        public AppConfigBuilder logFormatRfc3339(boolean logFormatRfc3339) {
            this.logFormatRfc3339 = logFormatRfc3339;
            this.logFormatRfc3339$set = true;
            return this;
        }

        public AppConfigBuilder confdDirectory(String confdDirectory) {
            this.confdDirectory = confdDirectory;
            return this;
        }

        public AppConfigBuilder tmpDirectory(String tmpDirectory) {
            this.tmpDirectory = tmpDirectory;
            this.tmpDirectory$set = true;
            return this;
        }

        public AppConfigBuilder reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public AppConfigBuilder yamlFileList(List<String> yamlFileList) {
            this.yamlFileList = yamlFileList;
            return this;
        }

        public AppConfigBuilder checkPeriod(int checkPeriod) {
            this.checkPeriod = checkPeriod;
            this.checkPeriod$set = true;
            return this;
        }

        public AppConfigBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            this.threadPoolSize$set = true;
            return this;
        }

        public AppConfigBuilder reconnectionThreadPoolSize(int reconnectionThreadPoolSize) {
            this.reconnectionThreadPoolSize = reconnectionThreadPoolSize;
            this.reconnectionThreadPoolSize$set = true;
            return this;
        }

        public AppConfigBuilder collectionTimeout(int collectionTimeout) {
            this.collectionTimeout = collectionTimeout;
            this.collectionTimeout$set = true;
            return this;
        }

        public AppConfigBuilder reconnectionTimeout(int reconnectionTimeout) {
            this.reconnectionTimeout = reconnectionTimeout;
            this.reconnectionTimeout$set = true;
            return this;
        }

        public AppConfigBuilder adEnabled(boolean adEnabled) {
            this.adEnabled = adEnabled;
            this.adEnabled$set = true;
            return this;
        }

        public AppConfigBuilder adPipe(String adPipe) {
            this.adPipe = adPipe;
            this.adPipe$set = true;
            return this;
        }

        public AppConfigBuilder statusLocation(String statusLocation) {
            this.statusLocation = statusLocation;
            return this;
        }

        public AppConfigBuilder exitWatcher(ExitWatcher exitWatcher) {
            this.exitWatcher = exitWatcher;
            this.exitWatcher$set = true;
            return this;
        }

        public AppConfigBuilder action(List<String> action) {
            this.action = action;
            return this;
        }

        public AppConfigBuilder ipcHost(String ipcHost) {
            this.ipcHost = ipcHost;
            return this;
        }

        public AppConfigBuilder ipcPort(int ipcPort) {
            this.ipcPort = ipcPort;
            this.ipcPort$set = true;
            return this;
        }

        public AppConfigBuilder targetDirectInstances(boolean targetDirectInstances) {
            this.targetDirectInstances = targetDirectInstances;
            this.targetDirectInstances$set = true;
            return this;
        }

        public AppConfigBuilder daemon(boolean daemon) {
            this.daemon = daemon;
            this.daemon$set = true;
            return this;
        }

        public AppConfigBuilder embedded(boolean embedded) {
            this.embedded = embedded;
            this.embedded$set = true;
            return this;
        }

        public AppConfigBuilder instanceConfigResources(List<String> instanceConfigResources) {
            this.instanceConfigResources = instanceConfigResources;
            return this;
        }

        public AppConfigBuilder metricConfigResources(List<String> metricConfigResources) {
            this.metricConfigResources = metricConfigResources;
            return this;
        }

        public AppConfigBuilder metricConfigFiles(List<String> metricConfigFiles) {
            this.metricConfigFiles = metricConfigFiles;
            return this;
        }

        public AppConfigBuilder refreshBeansPeriod(Integer refreshBeansPeriod) {
            this.refreshBeansPeriod = refreshBeansPeriod;
            return this;
        }

        public AppConfigBuilder globalTags(Map<String, String> globalTags) {
            this.globalTags = globalTags;
            return this;
        }

        public AppConfigBuilder status(Status status) {
            this.status = status;
            this.status$set = true;
            return this;
        }

        public AppConfig build() {
            String logLevel = this.logLevel;
            if (!this.logLevel$set) {
                logLevel = AppConfig.$default$logLevel();
            }
            boolean logFormatRfc3339 = this.logFormatRfc3339;
            if (!this.logFormatRfc3339$set) {
                logFormatRfc3339 = AppConfig.$default$logFormatRfc3339();
            }
            String tmpDirectory = this.tmpDirectory;
            if (!this.tmpDirectory$set) {
                tmpDirectory = AppConfig.$default$tmpDirectory();
            }
            int checkPeriod = this.checkPeriod;
            if (!this.checkPeriod$set) {
                checkPeriod = AppConfig.$default$checkPeriod();
            }
            int threadPoolSize = this.threadPoolSize;
            if (!this.threadPoolSize$set) {
                threadPoolSize = AppConfig.$default$threadPoolSize();
            }
            int reconnectionThreadPoolSize = this.reconnectionThreadPoolSize;
            if (!this.reconnectionThreadPoolSize$set) {
                reconnectionThreadPoolSize = AppConfig.$default$reconnectionThreadPoolSize();
            }
            int collectionTimeout = this.collectionTimeout;
            if (!this.collectionTimeout$set) {
                collectionTimeout = AppConfig.$default$collectionTimeout();
            }
            int reconnectionTimeout = this.reconnectionTimeout;
            if (!this.reconnectionTimeout$set) {
                reconnectionTimeout = AppConfig.$default$reconnectionTimeout();
            }
            boolean adEnabled = this.adEnabled;
            if (!this.adEnabled$set) {
                adEnabled = AppConfig.$default$adEnabled();
            }
            String adPipe = this.adPipe;
            if (!this.adPipe$set) {
                adPipe = AppConfig.$default$adPipe();
            }
            ExitWatcher exitWatcher = this.exitWatcher;
            if (!this.exitWatcher$set) {
                exitWatcher = AppConfig.$default$exitWatcher();
            }
            int ipcPort = this.ipcPort;
            if (!this.ipcPort$set) {
                ipcPort = AppConfig.$default$ipcPort();
            }
            boolean targetDirectInstances = this.targetDirectInstances;
            if (!this.targetDirectInstances$set) {
                targetDirectInstances = AppConfig.$default$targetDirectInstances();
            }
            boolean daemon = this.daemon;
            if (!this.daemon$set) {
                daemon = AppConfig.$default$daemon();
            }
            boolean embedded = this.embedded;
            if (!this.embedded$set) {
                embedded = AppConfig.$default$embedded();
            }
            Status status = this.status;
            if (!this.status$set) {
                status = AppConfig.$default$status();
            }
            return new AppConfig(this.help, this.version, logLevel, this.logLocation, logFormatRfc3339, this.confdDirectory, tmpDirectory, this.reporter, this.yamlFileList, checkPeriod, threadPoolSize, reconnectionThreadPoolSize, collectionTimeout, reconnectionTimeout, adEnabled, adPipe, this.statusLocation, exitWatcher, this.action, this.ipcHost, ipcPort, targetDirectInstances, daemon, embedded, this.instanceConfigResources, this.metricConfigResources, this.metricConfigFiles, this.refreshBeansPeriod, this.globalTags, status);
        }

        public String toString() {
            return "AppConfig.AppConfigBuilder(help=" + this.help + ", version=" + this.version + ", logLevel=" + this.logLevel + ", logLocation=" + this.logLocation + ", logFormatRfc3339=" + this.logFormatRfc3339 + ", confdDirectory=" + this.confdDirectory + ", tmpDirectory=" + this.tmpDirectory + ", reporter=" + this.reporter + ", yamlFileList=" + this.yamlFileList + ", checkPeriod=" + this.checkPeriod + ", threadPoolSize=" + this.threadPoolSize + ", reconnectionThreadPoolSize=" + this.reconnectionThreadPoolSize + ", collectionTimeout=" + this.collectionTimeout + ", reconnectionTimeout=" + this.reconnectionTimeout + ", adEnabled=" + this.adEnabled + ", adPipe=" + this.adPipe + ", statusLocation=" + this.statusLocation + ", exitWatcher=" + this.exitWatcher + ", action=" + this.action + ", ipcHost=" + this.ipcHost + ", ipcPort=" + this.ipcPort + ", targetDirectInstances=" + this.targetDirectInstances + ", daemon=" + this.daemon + ", embedded=" + this.embedded + ", instanceConfigResources=" + this.instanceConfigResources + ", metricConfigResources=" + this.metricConfigResources + ", metricConfigFiles=" + this.metricConfigFiles + ", refreshBeansPeriod=" + this.refreshBeansPeriod + ", globalTags=" + this.globalTags + ", status=" + this.status + ")";
        }
    }
}

