/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.HttpClient;
import org.yaml.snakeyaml.Yaml;

public class Status {
    public static final String STATUS_WARNING = "WARNING";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";
    private static final Logger LOGGER = Logger.getLogger((String)Status.class.getName());
    private static final String INITIALIZED_CHECKS = "initialized_checks";
    private static final String FAILED_CHECKS = "failed_checks";
    private static final String API_STATUS_PATH = "agent/jmx/status";
    private HashMap<String, Object> instanceStats;
    private ObjectMapper mapper;
    private String statusFileLocation;
    private HttpClient client;
    private boolean isEnabled;

    public Status() {
        this(null);
    }

    public Status(String host, int port) {
        this.mapper = new ObjectMapper();
        this.client = new HttpClient(host, port, false);
        this.configure(null, host, port);
    }

    public Status(String statusFileLocation) {
        this.configure(statusFileLocation, null, 0);
    }

    void configure(String statusFileLocation, String host, int port) {
        this.statusFileLocation = statusFileLocation;
        this.instanceStats = new HashMap();
        this.isEnabled = this.statusFileLocation != null || this.client != null;
        this.clearStats();
    }

    private void clearStats() {
        this.instanceStats.put(INITIALIZED_CHECKS, new HashMap());
        this.instanceStats.put(FAILED_CHECKS, new HashMap());
    }

    public void addInstanceStats(String checkName, String instance, int metricCount, int serviceCheckCount, String message, String status) {
        this.addStats(checkName, instance, metricCount, serviceCheckCount, message, status, INITIALIZED_CHECKS);
    }

    private void addStats(String checkName, String instance, int metricCount, int serviceCheckCount, String message, String status, String key) {
        LinkedList checkStats;
        HashMap initializedChecks = (HashMap)this.instanceStats.get(key);
        if (initializedChecks == null) {
            initializedChecks = new HashMap();
        }
        if ((checkStats = (LinkedList)initializedChecks.get(checkName)) == null) {
            checkStats = new LinkedList();
        }
        HashMap<String, Object> instStats = new HashMap<String, Object>();
        if (instance != null) {
            instStats.put("instance_name", instance);
        }
        if (metricCount != -1) {
            instStats.put("metric_count", metricCount);
        }
        if (serviceCheckCount != -1) {
            instStats.put("service_check_count", serviceCheckCount);
        }
        instStats.put("message", message);
        instStats.put("status", status);
        checkStats.add(instStats);
        initializedChecks.put(checkName, checkStats);
        this.instanceStats.put(key, initializedChecks);
    }

    public void addInitFailedCheck(String checkName, String message, String status) {
        this.addStats(checkName, null, -1, -1, message, status, FAILED_CHECKS);
    }

    private String generateYaml() {
        Yaml yaml = new Yaml();
        HashMap<String, Serializable> status = new HashMap<String, Serializable>();
        status.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        status.put("checks", this.instanceStats);
        return yaml.dump(status);
    }

    private String generateJson() throws JsonProcessingException {
        HashMap<String, Serializable> status = new HashMap<String, Serializable>();
        status.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        status.put("checks", this.instanceStats);
        return this.mapper.writeValueAsString(status);
    }

    public void flush() {
        if (this.isEnabled()) {
            if (this.client != null) {
                try {
                    String json = this.generateJson();
                    HttpClient.HttpResponse response = this.client.request("POST", json, API_STATUS_PATH);
                    if (!response.isResponse2xx()) {
                        LOGGER.debug((Object)("Problem submitting JSON status: " + json));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Could not post status: " + e.getMessage()));
                }
            } else {
                String yaml = this.generateYaml();
                try {
                    File statusFile = new File(this.statusFileLocation);
                    LOGGER.debug((Object)("Writing status to temp yaml file: " + statusFile.getAbsolutePath()));
                    FileUtils.writeStringToFile((File)statusFile, (String)yaml);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Cannot write status to temp file: " + e.getMessage()));
                }
            }
        }
        this.clearStats();
    }

    public String getStatusFileLocation() {
        return this.statusFileLocation;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

