/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JmxAttribute;

public class JmxComplexAttribute
extends JmxAttribute {
    private HashMap<String, HashMap<String, Object>> subAttributeList = new HashMap();

    public JmxComplexAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String instanceName, Connection connection, HashMap<String, String> instanceTags, boolean emptyDefaultHostname) {
        super(attribute, beanName, instanceName, connection, instanceTags, false, emptyDefaultHostname);
    }

    private void populateSubAttributeList(Object attributeValue) {
        block3: {
            String attributeType;
            block2: {
                attributeType = this.getAttribute().getType();
                if (!"javax.management.openmbean.CompositeData".equals(attributeType)) break block2;
                CompositeData data = (CompositeData)attributeValue;
                for (String key : data.getCompositeType().keySet()) {
                    this.subAttributeList.put(key, new HashMap());
                }
                break block3;
            }
            if (!"java.util.HashMap".equals(attributeType) && !"java.util.Map".equals(attributeType)) break block3;
            Map data = (Map)attributeValue;
            for (String key : data.keySet()) {
                this.subAttributeList.put(key, new HashMap());
            }
        }
    }

    @Override
    public LinkedList<HashMap<String, Object>> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        LinkedList<HashMap<String, Object>> metrics = new LinkedList<HashMap<String, Object>>();
        for (Map.Entry<String, HashMap<String, Object>> pair : this.subAttributeList.entrySet()) {
            String subAttribute = pair.getKey();
            HashMap<String, Object> metric = pair.getValue();
            if (metric.get("alias") == null) {
                metric.put("alias", JmxComplexAttribute.convertMetricName(this.getAlias(subAttribute)));
            }
            if (metric.get("metric_type") == null) {
                metric.put("metric_type", this.getMetricType(subAttribute));
            }
            if (metric.get("tags") == null) {
                metric.put("tags", this.getTags());
            }
            metric.put("value", this.castToDouble(this.getValue(subAttribute), subAttribute));
            metrics.add(metric);
        }
        return metrics;
    }

    private Object getValue(String subAttribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object value = this.getJmxValue();
        String attributeType = this.getAttribute().getType();
        if ("javax.management.openmbean.CompositeData".equals(attributeType)) {
            CompositeData data = (CompositeData)value;
            return data.get(subAttribute);
        }
        if ("java.util.HashMap".equals(attributeType) || "java.util.Map".equals(attributeType)) {
            Map data = (Map)value;
            return data.get(subAttribute);
        }
        throw new NumberFormatException();
    }

    private Object getMetricType(String subAttribute) {
        LinkedHashMap attribute;
        String subAttributeName = this.getAttribute().getName() + "." + subAttribute;
        String metricType = null;
        Filter include = this.getMatchingConf().getInclude();
        if (include.getAttribute() instanceof LinkedHashMap && (metricType = (String)((LinkedHashMap)(attribute = (LinkedHashMap)include.getAttribute()).get(subAttributeName)).get("metric_type")) == null) {
            metricType = (String)((LinkedHashMap)attribute.get(subAttributeName)).get("type");
        }
        if (metricType == null) {
            metricType = "gauge";
        }
        return metricType;
    }

    @Override
    public boolean match(Configuration configuration) {
        if (!this.matchDomain(configuration) || !this.matchBean(configuration) || this.excludeMatchDomain(configuration) || this.excludeMatchBean(configuration)) {
            return false;
        }
        try {
            this.populateSubAttributeList(this.getJmxValue());
        }
        catch (Exception e) {
            return false;
        }
        return this.matchAttribute(configuration) && !this.excludeMatchAttribute(configuration);
    }

    private boolean matchSubAttribute(Filter params, String subAttributeName, boolean matchOnEmpty) {
        if (params.getAttribute() instanceof LinkedHashMap && ((LinkedHashMap)params.getAttribute()).containsKey(subAttributeName)) {
            return true;
        }
        if (params.getAttribute() instanceof ArrayList && ((ArrayList)params.getAttribute()).contains(subAttributeName)) {
            return true;
        }
        if (params.getAttribute() == null) {
            return matchOnEmpty;
        }
        return false;
    }

    private boolean matchAttribute(Configuration configuration) {
        if (this.matchSubAttribute(configuration.getInclude(), this.getAttributeName(), true)) {
            return true;
        }
        Iterator<String> it = this.subAttributeList.keySet().iterator();
        while (it.hasNext()) {
            String subAttribute = it.next();
            if (this.matchSubAttribute(configuration.getInclude(), this.getAttributeName() + "." + subAttribute, true)) continue;
            it.remove();
        }
        return this.subAttributeList.size() > 0;
    }

    private boolean excludeMatchAttribute(Configuration configuration) {
        Filter exclude = configuration.getExclude();
        if (exclude.getAttribute() != null && this.matchSubAttribute(exclude, this.getAttributeName(), false)) {
            return true;
        }
        Iterator<String> it = this.subAttributeList.keySet().iterator();
        while (it.hasNext()) {
            String subAttribute = it.next();
            if (!this.matchSubAttribute(exclude, this.getAttributeName() + "." + subAttribute, false)) continue;
            it.remove();
        }
        return this.subAttributeList.size() <= 0;
    }
}

