/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogger {
    private static final Logger log = LoggerFactory.getLogger(CustomLogger.class);
    private static final Multiset<String> messageCount = HashMultiset.create();
    private static final String LOGGER_LAYOUT = "%d | %-5p| %c{1} | %m%n";
    private static final String SYSTEM_OUT_ALT = "STDOUT";
    private static final String SYSTEM_ERR_ALT = "STDERR";

    public static void setup(Level level, String logLocation) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        String target = "CONSOLE";
        if (!(logLocation == null || ConsoleAppender.Target.SYSTEM_ERR.toString().equals(logLocation) || SYSTEM_ERR_ALT.equals(logLocation) || ConsoleAppender.Target.SYSTEM_OUT.toString().equals(logLocation) || SYSTEM_OUT_ALT.equals(logLocation))) {
            target = "FileLogger";
            PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(LOGGER_LAYOUT).build();
            RollingFileAppender fa = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setConfiguration(config)).withName(target)).withLayout((Layout)layout)).withFileName(logLocation).withFilePattern(logLocation + ".%d").withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)"5MB")).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax("1").build()).build();
            fa.start();
            config.addAppender((Appender)fa);
            ctx.getRootLogger().addAppender(config.getAppender(fa.getName()));
            log.info("File Handler set");
        } else if (logLocation != null && (ConsoleAppender.Target.SYSTEM_ERR.toString().equals(logLocation) || SYSTEM_ERR_ALT.equals(logLocation))) {
            ConsoleAppender console = (ConsoleAppender)config.getAppender("CONSOLE");
            console.stop();
            config.getRootLogger().removeAppender("CONSOLE");
            ctx.updateLoggers();
            PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern(LOGGER_LAYOUT).build();
            ConsoleAppender ca = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setConfiguration(config)).withName(logLocation)).setTarget(ConsoleAppender.Target.SYSTEM_ERR).withLayout((Layout)layout)).build();
            ca.start();
            config.addAppender((Appender)ca);
            ctx.getRootLogger().addAppender(config.getAppender(ca.getName()));
        }
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static void laconic(Logger logger, Level level, String message, int max) {
        if (messageCount.count((Object)message) <= max) {
            if (level.isInRange(Level.ERROR, Level.ALL)) {
                logger.error(message);
            } else if (level == Level.WARN) {
                logger.warn(message);
            } else if (level == Level.INFO) {
                logger.info(message);
            } else if (level == Level.DEBUG) {
                logger.debug(message);
            }
            messageCount.add((Object)message);
        }
    }

    private CustomLogger() {
    }
}

