/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDClient;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JMXAttribute;
import org.datadog.jmxfetch.reporter.Reporter;

public class StatsdReporter
extends Reporter {
    private StatsDClient statsDClient;
    private String statsdHost;
    private int statsdPort;
    private long initializationTime;

    public StatsdReporter(String statsdHost, int statsdPort) {
        this.statsdHost = statsdHost;
        this.statsdPort = statsdPort;
        this.init();
    }

    private void init() {
        this.initializationTime = System.currentTimeMillis();
        this.statsDClient = new NonBlockingStatsDClient(null, this.statsdHost, this.statsdPort, new String[0]);
    }

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        if (System.currentTimeMillis() - this.initializationTime > 300000L) {
            this.statsDClient.stop();
            this.init();
        }
        if (metricType.equals("histogram")) {
            this.statsDClient.histogram(metricName, value, tags);
        } else {
            this.statsDClient.gauge(metricName, value, tags);
        }
    }

    private int statusToInt(String status) {
        if (status == "OK") {
            return 0;
        }
        if (status == "WARNING") {
            return 1;
        }
        if (status == "ERROR") {
            return 2;
        }
        return 3;
    }

    @Override
    public void doSendServiceCheck(String checkName, String status, String message, String[] tags) {
        if (System.currentTimeMillis() - this.initializationTime > 300000L) {
            this.statsDClient.stop();
            this.init();
        }
        ServiceCheck sc = new ServiceCheck(String.format("%s.can_connect", checkName), this.statusToInt(status), message, tags);
        this.statsDClient.serviceCheck(sc);
    }

    @Override
    public void displayMetricReached() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayMatchingAttributeName(JMXAttribute jmxAttribute, int rank, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayNonMatchingAttributeName(JMXAttribute jmxAttribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void displayInstanceName(Instance instance) {
        throw new UnsupportedOperationException();
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }
}

