/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.Status;

public class HttpClient {
    private String token;
    private TrustManager[] dummyTrustManager;
    private SSLContext sc;
    private String host;
    private int port;
    private static final String USER_AGENT = "Datadog/JMXFetch";
    private static final Logger LOGGER = Logger.getLogger((String)Status.class.getName());

    public HttpClient(String host, int port, boolean verify) {
        this.host = host;
        this.port = port;
        this.token = System.getenv("SESSION_TOKEN");
        if (!verify) {
            try {
                this.dummyTrustManager = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                this.sc = SSLContext.getInstance("SSL");
                this.sc.init(null, this.dummyTrustManager, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(this.sc.getSocketFactory());
            }
            catch (Exception e) {
                LOGGER.debug((Object)"session token unavailable - not setting");
                this.token = "";
            }
        }
    }

    public HttpResponse request(String method, String body, String path) {
        HttpResponse response = new HttpResponse(0, "");
        try {
            String url = "https://" + this.host + ":" + this.port + "/" + path;
            LOGGER.debug((Object)("attempting to connect to: " + url));
            LOGGER.debug((Object)("with body: " + body));
            URL uri = new URL(url);
            HttpsURLConnection con = (HttpsURLConnection)uri.openConnection();
            con.setRequestMethod(method.toUpperCase());
            con.setRequestProperty("Authorization", "Bearer " + this.token);
            con.setRequestProperty("User-Agent", USER_AGENT);
            if (method.toUpperCase().equals("GET")) {
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else {
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.writeBytes(body);
                wr.flush();
                wr.close();
            }
            int responseCode = con.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                LOGGER.debug((Object)("HTTP error stream: " + con.getErrorStream()));
                response.setResponseCode(responseCode);
            } else {
                response = new HttpResponse(responseCode, new InputStreamReader(con.getInputStream()));
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("problem creating http request: " + e.toString()));
        }
        return response;
    }

    public static class HttpResponse {
        private int responseCode;
        private String responseBody;

        public HttpResponse(int responseCode, String responseBody) {
            this.responseCode = responseCode;
            this.responseBody = responseBody;
        }

        public HttpResponse(int responseCode, InputStreamReader responseStream) throws IOException {
            String inputLine;
            BufferedReader in = new BufferedReader(responseStream);
            StringBuffer responseBuilder = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                responseBuilder.append(inputLine);
            }
            in.close();
            this.responseCode = responseCode;
            this.responseBody = responseBuilder.toString();
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        public boolean isResponse2xx() {
            return this.responseCode >= 200 && this.responseCode < 300;
        }
    }
}

