/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.InvalidMessageException;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDAggregator;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.Telemetry;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;

public abstract class StatsDProcessor {
    protected static final String MESSAGE_TOO_LONG = "Message longer than size of sendBuffer";
    protected static final int WAIT_SLEEP_MS = 10;
    protected final StatsDClientErrorHandler handler;
    final int maxPacketSizeBytes;
    protected final BufferPool bufferPool;
    protected final Queue<Message> highPrioMessages;
    protected final BlockingQueue<ByteBuffer> outboundQueue;
    protected final CountDownLatch endSignal;
    final CountDownLatch closeSignal;
    protected final ThreadFactory threadFactory;
    protected final Thread[] workers;
    protected final int qcapacity;
    protected StatsDAggregator aggregator;
    protected volatile Telemetry telemetry;
    protected volatile boolean shutdown;
    volatile boolean shutdownAgg;

    StatsDProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers, int aggregatorFlushInterval, int aggregatorShards, ThreadFactory threadFactory) throws Exception {
        this.handler = handler;
        this.threadFactory = threadFactory;
        this.workers = new Thread[workers];
        this.qcapacity = queueSize;
        this.maxPacketSizeBytes = maxPacketSizeBytes;
        this.bufferPool = new BufferPool(poolSize, maxPacketSizeBytes, true);
        this.highPrioMessages = new ConcurrentLinkedQueue<Message>();
        this.outboundQueue = new ArrayBlockingQueue<ByteBuffer>(poolSize);
        this.endSignal = new CountDownLatch(workers);
        this.closeSignal = new CountDownLatch(workers);
        this.aggregator = new StatsDAggregator(this, aggregatorShards, aggregatorFlushInterval);
    }

    protected abstract ProcessingTask createProcessingTask();

    protected abstract boolean send(Message var1);

    protected boolean sendHighPrio(Message message) {
        this.highPrioMessages.offer(message);
        return true;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public BlockingQueue<ByteBuffer> getOutboundQueue() {
        return this.outboundQueue;
    }

    public int getQcapacity() {
        return this.qcapacity;
    }

    void startWorkers(String namePrefix) {
        this.aggregator.start();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.threadFactory.newThread(this.createProcessingTask());
            this.workers[i].setName(namePrefix + (i + 1));
            this.workers[i].start();
        }
    }

    public StatsDAggregator getAggregator() {
        return this.aggregator;
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    void shutdown(boolean blocking) throws InterruptedException {
        this.shutdown = true;
        this.aggregator.stop();
        if (blocking) {
            this.closeSignal.await();
            this.aggregator.flush();
            this.shutdownAgg = true;
            this.endSignal.await();
        } else {
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i].interrupt();
            }
        }
    }

    protected abstract class ProcessingTask
    implements Runnable {
        protected StringBuilder builder = new StringBuilder();
        char[] charBuffer;
        final byte[] byteBuffer;

        protected ProcessingTask() {
            this.charBuffer = new char[StatsDProcessor.this.maxPacketSizeBytes];
            this.byteBuffer = new byte[StatsDProcessor.this.maxPacketSizeBytes + 4];
        }

        @Override
        public final void run() {
            try {
                this.processLoop();
            }
            finally {
                StatsDProcessor.this.endSignal.countDown();
            }
        }

        protected void processLoop() {
            ByteBuffer sendBuffer;
            try {
                sendBuffer = StatsDProcessor.this.bufferPool.borrow();
            }
            catch (InterruptedException e) {
                return;
            }
            boolean clientClosed = false;
            while (!Thread.interrupted()) {
                try {
                    boolean partialWrite;
                    boolean shutdown = StatsDProcessor.this.shutdown;
                    boolean shutdownAgg = StatsDProcessor.this.shutdownAgg;
                    Message message = StatsDProcessor.this.highPrioMessages.poll();
                    if (message == null && shutdownAgg) break;
                    if (message == null && !clientClosed) {
                        message = this.getMessage();
                    }
                    if (message == null) {
                        if (shutdown && !clientClosed) {
                            StatsDProcessor.this.closeSignal.countDown();
                            clientClosed = true;
                        }
                        if (!clientClosed) continue;
                        Thread.sleep(10L);
                        continue;
                    }
                    if (StatsDProcessor.this.aggregator.aggregateMessage(message)) continue;
                    do {
                        this.builder.setLength(0);
                        partialWrite = message.writeTo(this.builder, sendBuffer.capacity());
                        int lowerBoundSize = this.builder.length();
                        if (sendBuffer.capacity() < lowerBoundSize) {
                            throw new InvalidMessageException(StatsDProcessor.MESSAGE_TOO_LONG, this.builder.toString());
                        }
                        if (sendBuffer.remaining() < lowerBoundSize + 1) {
                            StatsDProcessor.this.outboundQueue.put(sendBuffer);
                            sendBuffer = StatsDProcessor.this.bufferPool.borrow();
                        }
                        try {
                            this.writeBuilderToSendBuffer(sendBuffer);
                        }
                        catch (BufferOverflowException boe) {
                            StatsDProcessor.this.outboundQueue.put(sendBuffer);
                            sendBuffer = StatsDProcessor.this.bufferPool.borrow();
                            this.writeBuilderToSendBuffer(sendBuffer);
                        }
                    } while (partialWrite);
                    if (this.haveMessages()) continue;
                    StatsDProcessor.this.outboundQueue.put(sendBuffer);
                    sendBuffer = StatsDProcessor.this.bufferPool.borrow();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    StatsDProcessor.this.handler.handle(e);
                }
            }
            this.builder.setLength(0);
            this.builder.trimToSize();
        }

        abstract boolean haveMessages();

        abstract Message getMessage() throws InterruptedException;

        protected void writeBuilderToSendBuffer(ByteBuffer sendBuffer) {
            int length = this.builder.length();
            if (length > this.charBuffer.length) {
                this.charBuffer = new char[length];
            }
            this.builder.getChars(0, length, this.charBuffer, 0);
            int blen = 0;
            for (int i = 0; i < length; ++i) {
                char ch = this.charBuffer[i];
                if (ch < '\u0080') {
                    this.byteBuffer[blen++] = (byte)ch;
                } else if (ch < '\u0800') {
                    this.byteBuffer[blen++] = (byte)(0xC0 | ch >> 6);
                    this.byteBuffer[blen++] = (byte)(0x80 | ch & 0x3F);
                } else if (ch < '\ud800' || ch >= '\ue000') {
                    this.byteBuffer[blen++] = (byte)(0xE0 | ch >> 12);
                    this.byteBuffer[blen++] = (byte)(0x80 | ch >> 6 & 0x3F);
                    this.byteBuffer[blen++] = (byte)(0x80 | ch & 0x3F);
                } else {
                    int decoded = (ch & 0x3FF) << 10 | this.charBuffer[++i] & 0x3FF | 0x10000;
                    this.byteBuffer[blen++] = (byte)(0xF0 | decoded >> 18);
                    this.byteBuffer[blen++] = (byte)(0x80 | decoded >> 12 & 0x3F);
                    this.byteBuffer[blen++] = (byte)(0x80 | decoded >> 6 & 0x3F);
                    this.byteBuffer[blen++] = (byte)(0x80 | decoded & 0x3F);
                }
                if (blen < StatsDProcessor.this.maxPacketSizeBytes) continue;
                throw new BufferOverflowException();
            }
            sendBuffer.mark();
            sendBuffer.put(this.byteBuffer, 0, blen);
        }
    }
}

