/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDProcessor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class StatsDNonBlockingProcessor
extends StatsDProcessor {
    private final Queue<Message> messages;
    private final AtomicInteger qsize = new AtomicInteger(0);

    StatsDNonBlockingProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers, int aggregatorFlushInterval, int aggregatorShards, ThreadFactory threadFactory, String containerID) throws Exception {
        super(queueSize, handler, maxPacketSizeBytes, poolSize, workers, aggregatorFlushInterval, aggregatorShards, threadFactory, containerID);
        this.messages = new ConcurrentLinkedQueue<Message>();
    }

    @Override
    protected ProcessingTask createProcessingTask() {
        return new ProcessingTask();
    }

    @Override
    protected boolean send(Message message) {
        if (!this.shutdown && this.qsize.get() < this.qcapacity) {
            this.messages.offer(message);
            this.qsize.incrementAndGet();
            return true;
        }
        return false;
    }

    private class ProcessingTask
    extends StatsDProcessor.ProcessingTask {
        private ProcessingTask() {
        }

        @Override
        protected Message getMessage() throws InterruptedException {
            Message message = (Message)StatsDNonBlockingProcessor.this.messages.poll();
            if (message != null) {
                StatsDNonBlockingProcessor.this.qsize.decrementAndGet();
                return message;
            }
            Thread.sleep(10L);
            return null;
        }

        @Override
        protected boolean haveMessages() {
            return !StatsDNonBlockingProcessor.this.messages.isEmpty();
        }
    }
}

