/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.AlphaNumericMessage;
import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.Event;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.NumericMessage;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDBlockingProcessor;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import com.timgroup.statsd.StatsDNonBlockingProcessor;
import com.timgroup.statsd.StatsDProcessor;
import com.timgroup.statsd.StatsDSender;
import com.timgroup.statsd.StatsDThreadFactory;
import com.timgroup.statsd.Telemetry;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketOptions;

public class NonBlockingStatsDClient
implements StatsDClient {
    public static final String DD_DOGSTATSD_PORT_ENV_VAR = "DD_DOGSTATSD_PORT";
    public static final String DD_AGENT_HOST_ENV_VAR = "DD_AGENT_HOST";
    public static final String DD_ENTITY_ID_ENV_VAR = "DD_ENTITY_ID";
    private static final String ENTITY_ID_TAG_NAME = "dd.internal.entity_id";
    public static final int DEFAULT_UDP_MAX_PACKET_SIZE_BYTES = 1432;
    public static final int DEFAULT_UDS_MAX_PACKET_SIZE_BYTES = 8192;
    public static final int DEFAULT_QUEUE_SIZE = 4096;
    public static final int DEFAULT_POOL_SIZE = 512;
    public static final int DEFAULT_PROCESSOR_WORKERS = 1;
    public static final int DEFAULT_SENDER_WORKERS = 1;
    public static final int DEFAULT_DOGSTATSD_PORT = 8125;
    public static final int SOCKET_TIMEOUT_MS = 100;
    public static final int SOCKET_BUFFER_BYTES = -1;
    public static final boolean DEFAULT_BLOCKING = false;
    public static final boolean DEFAULT_ENABLE_TELEMETRY = true;
    public static final boolean DEFAULT_ENABLE_DEVMODE = false;
    public static final boolean DEFAULT_ENABLE_AGGREGATION = false;
    public static final String CLIENT_TAG = "client:java";
    public static final String CLIENT_VERSION_TAG = "client_version:";
    public static final String CLIENT_TRANSPORT_TAG = "client_transport:";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception ex) {
        }
    };
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(false);
        }
    };
    private static final ThreadLocal<NumberFormat> SAMPLE_RATE_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(true);
        }
    };
    private final String prefix;
    private final DatagramChannel clientChannel;
    private final StatsDClientErrorHandler handler;
    private final String constantTagsRendered;
    protected final StatsDProcessor statsDProcessor;
    protected StatsDProcessor telemetryStatsDProcessor;
    protected final StatsDSender statsDSender;
    protected StatsDSender telemetryStatsDSender;
    protected final Telemetry telemetry;

    private static NumberFormat newFormatter(boolean sampler) {
        NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
        numberFormatter.setGroupingUsed(false);
        if (numberFormatter instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
            DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
            symbols.setNaN("NaN");
            decimalFormat.setDecimalFormatSymbols(symbols);
        }
        if (sampler) {
            numberFormatter.setMinimumFractionDigits(6);
        } else {
            numberFormatter.setMaximumFractionDigits(6);
        }
        return numberFormatter;
    }

    private static String format(ThreadLocal<NumberFormat> formatter, Number value) {
        return formatter.get().format(value);
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, Callable<SocketAddress> telemetryAddressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID, int poolSize, int processorWorkers, int senderWorkers, boolean blocking, boolean enableTelemetry, int telemetryFlushInterval, boolean enableDevMode, int aggregationFlushInterval, int aggregationShards) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, addressLookup, telemetryAddressLookup, timeout, bufferSize, maxPacketSizeBytes, entityID, poolSize, processorWorkers, senderWorkers, blocking, enableTelemetry, telemetryFlushInterval, enableDevMode, aggregationFlushInterval, aggregationShards, null);
    }

    private NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, Callable<SocketAddress> telemetryAddressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID, int poolSize, int processorWorkers, int senderWorkers, boolean blocking, boolean enableTelemetry, int telemetryFlushInterval, boolean enableDevMode, int aggregationFlushInterval, int aggregationShards, ThreadFactory customThreadFactory) throws StatsDClientException {
        this.prefix = prefix != null && !prefix.isEmpty() ? prefix + "." : "";
        this.handler = errorHandler == null ? NO_OP_HANDLER : errorHandler;
        ArrayList<String> costantPreTags = new ArrayList<String>();
        if (constantTags != null) {
            for (String string : constantTags) {
                costantPreTags.add(string);
            }
        }
        NonBlockingStatsDClient.updateTagsWithEntityID(costantPreTags, entityID);
        for (Literal literal : Literal.values()) {
            String envVal = literal.envVal();
            if (envVal == null || envVal.trim().isEmpty()) continue;
            costantPreTags.add(literal.tag() + ":" + envVal);
        }
        this.constantTagsRendered = costantPreTags.isEmpty() ? null : NonBlockingStatsDClient.tagString(costantPreTags.toArray(new String[costantPreTags.size()]), null, new StringBuilder()).toString();
        costantPreTags = null;
        String transportType = "";
        try {
            SocketAddress socketAddress = addressLookup.call();
            if (socketAddress instanceof UnixSocketAddress) {
                this.clientChannel = UnixDatagramChannel.open();
                if (timeout > 0) {
                    this.clientChannel.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)timeout);
                }
                if (bufferSize > 0) {
                    this.clientChannel.setOption(UnixSocketOptions.SO_SNDBUF, (Object)bufferSize);
                }
                transportType = "uds";
            } else {
                this.clientChannel = DatagramChannel.open();
                transportType = "udp";
            }
            ThreadFactory threadFactory = customThreadFactory != null ? customThreadFactory : new StatsDThreadFactory();
            this.telemetryStatsDProcessor = this.statsDProcessor = this.createProcessor(queueSize, this.handler, maxPacketSizeBytes, poolSize, processorWorkers, blocking, aggregationFlushInterval, aggregationShards, threadFactory);
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("dogstatsd/version.properties"));
            String string = this.tagString(new String[]{CLIENT_TRANSPORT_TAG + transportType, CLIENT_VERSION_TAG + properties.getProperty("dogstatsd_client_version"), CLIENT_TAG}, new StringBuilder()).toString();
            DatagramChannel telemetryClientChannel = this.clientChannel;
            if (addressLookup != telemetryAddressLookup) {
                SocketAddress telemetryAddress = telemetryAddressLookup.call();
                if (telemetryAddress instanceof UnixSocketAddress) {
                    telemetryClientChannel = UnixDatagramChannel.open();
                    if (timeout > 0) {
                        telemetryClientChannel.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)timeout);
                    }
                    if (bufferSize > 0) {
                        telemetryClientChannel.setOption(UnixSocketOptions.SO_SNDBUF, (Object)bufferSize);
                    }
                } else if (transportType == "uds") {
                    telemetryClientChannel = DatagramChannel.open();
                }
                this.telemetryStatsDProcessor = this.createProcessor(queueSize, this.handler, maxPacketSizeBytes, poolSize, 1, false, 0, aggregationShards, threadFactory);
            }
            this.telemetry = new Telemetry.Builder().tags(string).processor(this.telemetryStatsDProcessor).devMode(enableDevMode).build();
            this.telemetryStatsDSender = this.statsDSender = this.createSender(addressLookup, this.handler, this.clientChannel, this.statsDProcessor.getBufferPool(), this.statsDProcessor.getOutboundQueue(), senderWorkers, threadFactory);
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDSender = this.createSender(telemetryAddressLookup, this.handler, telemetryClientChannel, this.telemetryStatsDProcessor.getBufferPool(), this.telemetryStatsDProcessor.getOutboundQueue(), 1, threadFactory);
            }
            this.statsDProcessor.setTelemetry(this.telemetry);
            this.statsDSender.setTelemetry(this.telemetry);
        }
        catch (Exception exception) {
            throw new StatsDClientException("Failed to start StatsD client", exception);
        }
        this.statsDProcessor.startWorkers("StatsD-Processor-");
        this.statsDSender.startWorkers("StatsD-Sender-");
        if (enableTelemetry) {
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.startWorkers("StatsD-TelemetryProcessor-");
                this.telemetryStatsDSender.startWorkers("StatsD-TelemetrySender-");
            }
            this.telemetry.start(telemetryFlushInterval);
        }
    }

    NonBlockingStatsDClient(NonBlockingStatsDClientBuilder builder) throws StatsDClientException {
        this(builder.prefix, builder.queueSize, builder.constantTags, builder.errorHandler, builder.addressLookup, builder.telemetryAddressLookup, builder.timeout, builder.socketBufferSize, builder.maxPacketSizeBytes, builder.entityID, builder.bufferPoolSize, builder.processorWorkers, builder.senderWorkers, builder.blocking, builder.enableTelemetry, builder.telemetryFlushInterval, builder.enableDevMode, builder.enableAggregation ? builder.aggregationFlushInterval : 0, builder.aggregationShards, builder.threadFactory);
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, String ... constantTags) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).constantTags(constantTags).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, String[] constantTags, int maxPacketSizeBytes) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).constantTags(constantTags).maxPacketSizeBytes(maxPacketSizeBytes).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String ... constantTags) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).constantTags(constantTags).errorHandler(errorHandler).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, String entityID) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).entityID(entityID).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, int maxPacketSizeBytes) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).maxPacketSizeBytes(maxPacketSizeBytes).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, int timeout, int bufferSize, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).timeout(timeout).socketBufferSize(bufferSize).constantTags(constantTags).errorHandler(errorHandler).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).addressLookup(addressLookup).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).addressLookup(addressLookup).timeout(timeout).socketBufferSize(bufferSize).resolve());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize, int maxPacketSizeBytes) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).addressLookup(addressLookup).timeout(timeout).socketBufferSize(bufferSize).maxPacketSizeBytes(maxPacketSizeBytes).resolve());
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID, int poolSize, int processorWorkers, int senderWorkers, boolean blocking, boolean enableTelemetry, int telemetryFlushInterval) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, addressLookup, addressLookup, timeout, bufferSize, maxPacketSizeBytes, entityID, poolSize, processorWorkers, senderWorkers, blocking, enableTelemetry, telemetryFlushInterval, false, 0, 0);
    }

    protected StatsDProcessor createProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int bufferPoolSize, int workers, boolean blocking, int aggregationFlushInterval, int aggregationShards, ThreadFactory threadFactory) throws Exception {
        if (blocking) {
            return new StatsDBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers, aggregationFlushInterval, aggregationShards, threadFactory);
        }
        return new StatsDNonBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers, aggregationFlushInterval, aggregationShards, threadFactory);
    }

    protected StatsDSender createSender(Callable<SocketAddress> addressLookup, StatsDClientErrorHandler handler, DatagramChannel clientChannel, BufferPool pool, BlockingQueue<ByteBuffer> buffers, int senderWorkers, ThreadFactory threadFactory) throws Exception {
        return new StatsDSender(addressLookup, clientChannel, handler, pool, buffers, senderWorkers, threadFactory);
    }

    @Override
    public void stop() {
        try {
            this.telemetry.stop();
            this.statsDProcessor.shutdown();
            this.statsDSender.shutdown();
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.shutdown();
                this.telemetryStatsDSender.shutdown();
            }
            long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
            this.statsDProcessor.awaitUntil(deadline);
            this.statsDSender.awaitUntil(deadline);
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
        finally {
            if (this.clientChannel != null) {
                try {
                    this.clientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    static StringBuilder tagString(String[] tags, String tagPrefix, StringBuilder sb) {
        if (tagPrefix != null) {
            sb.append(tagPrefix);
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append(',');
        } else {
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append("|#");
        }
        for (int n = tags.length - 1; n >= 0; --n) {
            sb.append(tags[n]);
            if (n <= 0) continue;
            sb.append(',');
        }
        return sb;
    }

    StringBuilder tagString(String[] tags, StringBuilder builder) {
        return NonBlockingStatsDClient.tagString(tags, this.constantTagsRendered, builder);
    }

    private boolean sendMetric(Message message) {
        return this.send(message);
    }

    private boolean send(Message message) {
        boolean success = this.statsDProcessor.send(message);
        if (success) {
            this.telemetry.incrMetricsSent(1, message.getType());
        } else {
            this.telemetry.incrPacketDroppedQueue(1);
        }
        return success;
    }

    private void send(String aspect, double value, Message.Type type, double sampleRate, String[] tags) {
        if (this.statsDProcessor.getAggregator().getFlushInterval() != 0L && !Double.isNaN(sampleRate)) {
            switch (type) {
                case COUNT: {
                    sampleRate = Double.NaN;
                    break;
                }
            }
        }
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage<Double>(aspect, type, Double.valueOf(value), sampleRate, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(NonBlockingStatsDClient.format(NUMBER_FORMATTER, this.value));
                }
            });
        }
    }

    private void send(String aspect, double value, Message.Type type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, tags);
    }

    private void send(String aspect, long value, Message.Type type, double sampleRate, String[] tags) {
        if (this.statsDProcessor.getAggregator().getFlushInterval() != 0L && !Double.isNaN(sampleRate)) {
            switch (type) {
                case COUNT: {
                    sampleRate = Double.NaN;
                    break;
                }
            }
        }
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage<Long>(aspect, type, Long.valueOf(value), sampleRate, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(this.value);
                }
            });
        }
    }

    private void send(String aspect, long value, Message.Type type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, tags);
    }

    @Override
    public void count(String aspect, long delta, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, tags);
    }

    @Override
    public void count(String aspect, long delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, tags);
    }

    @Override
    public void count(String aspect, double delta, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, tags);
    }

    @Override
    public void count(String aspect, double delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, tags);
    }

    @Override
    public void incrementCounter(String aspect, String ... tags) {
        this.count(aspect, 1L, tags);
    }

    @Override
    public void incrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, 1L, sampleRate, tags);
    }

    @Override
    public void increment(String aspect, String ... tags) {
        this.incrementCounter(aspect, tags);
    }

    @Override
    public void increment(String aspect, double sampleRate, String ... tags) {
        this.incrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void decrementCounter(String aspect, String ... tags) {
        this.count(aspect, -1L, tags);
    }

    @Override
    public void decrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, -1L, sampleRate, tags);
    }

    @Override
    public void decrement(String aspect, String ... tags) {
        this.decrementCounter(aspect, tags);
    }

    @Override
    public void decrement(String aspect, double sampleRate, String ... tags) {
        this.decrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, double value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, double value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, long value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, long value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, double sampleRate, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, sampleRate, tags);
    }

    @Override
    public void time(String aspect, long value, String ... tags) {
        this.recordExecutionTime(aspect, value, tags);
    }

    @Override
    public void time(String aspect, long value, double sampleRate, String ... tags) {
        this.recordExecutionTime(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, double value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, double value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, long value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, long value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, double value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, double value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, long value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, long value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    private StringBuilder eventMap(Event event, StringBuilder res) {
        String sourceTypeName;
        String alertType;
        String priority;
        String aggregationKey;
        String hostname;
        long millisSinceEpoch = event.getMillisSinceEpoch();
        if (millisSinceEpoch != -1L) {
            res.append("|d:").append(millisSinceEpoch / 1000L);
        }
        if ((hostname = event.getHostname()) != null) {
            res.append("|h:").append(hostname);
        }
        if ((aggregationKey = event.getAggregationKey()) != null) {
            res.append("|k:").append(aggregationKey);
        }
        if ((priority = event.getPriority()) != null) {
            res.append("|p:").append(priority);
        }
        if ((alertType = event.getAlertType()) != null) {
            res.append("|t:").append(alertType);
        }
        if ((sourceTypeName = event.getSourceTypeName()) != null) {
            res.append("|s:").append(sourceTypeName);
        }
        return res;
    }

    @Override
    public void recordEvent(final Event event, final String ... eventTags) {
        this.statsDProcessor.send(new AlphaNumericMessage(Message.Type.EVENT, ""){

            @Override
            public void writeTo(StringBuilder builder) {
                String title = NonBlockingStatsDClient.escapeEventString(NonBlockingStatsDClient.this.prefix + event.getTitle());
                String text = NonBlockingStatsDClient.escapeEventString(event.getText());
                builder.append(Message.Type.EVENT.toString()).append("{").append(NonBlockingStatsDClient.this.getUtf8Length(title)).append(",").append(NonBlockingStatsDClient.this.getUtf8Length(text)).append("}:").append(title).append("|").append(text);
                NonBlockingStatsDClient.this.eventMap(event, builder);
                NonBlockingStatsDClient.this.tagString(eventTags, builder);
                builder.append('\n');
            }
        });
        this.telemetry.incrEventsSent(1);
    }

    private static String escapeEventString(String title) {
        return title.replace("\n", "\\n");
    }

    private int getUtf8Length(String text) {
        return text.getBytes(UTF_8).length;
    }

    @Override
    public void recordServiceCheckRun(final ServiceCheck sc) {
        this.statsDProcessor.send(new AlphaNumericMessage(Message.Type.SERVICE_CHECK, ""){

            @Override
            public void writeTo(StringBuilder sb) {
                sb.append(Message.Type.SERVICE_CHECK.toString()).append("|").append(sc.getName()).append("|").append(sc.getStatus());
                if (sc.getTimestamp() > 0) {
                    sb.append("|d:").append(sc.getTimestamp());
                }
                if (sc.getHostname() != null) {
                    sb.append("|h:").append(sc.getHostname());
                }
                NonBlockingStatsDClient.this.tagString(sc.getTags(), sb);
                if (sc.getMessage() != null) {
                    sb.append("|m:").append(sc.getEscapedMessage());
                }
                sb.append('\n');
            }
        });
        this.telemetry.incrServiceChecksSent(1);
    }

    private static boolean updateTagsWithEntityID(List<String> tags, String entityID) {
        if (entityID == null || entityID.trim().isEmpty()) {
            entityID = System.getenv(DD_ENTITY_ID_ENV_VAR);
        }
        if (entityID != null && !entityID.trim().isEmpty()) {
            String entityTag = "dd.internal.entity_id:" + entityID;
            return tags.add(entityTag);
        }
        return false;
    }

    @Override
    public void serviceCheck(ServiceCheck sc) {
        this.recordServiceCheckRun(sc);
    }

    @Override
    public void recordSetValue(String aspect, String val, String ... tags) {
        this.statsDProcessor.send(new AlphaNumericMessage(aspect, Message.Type.SET, val, tags){

            protected void writeValue(StringBuilder builder) {
                builder.append(this.getValue());
            }

            @Override
            protected final void writeTo(StringBuilder builder) {
                builder.append(NonBlockingStatsDClient.this.prefix).append(this.aspect).append(':');
                this.writeValue(builder);
                builder.append('|').append((Object)this.type);
                NonBlockingStatsDClient.this.tagString(this.tags, builder);
                builder.append('\n');
            }
        });
    }

    private boolean isInvalidSample(double sampleRate) {
        return sampleRate != 1.0 && ThreadLocalRandom.current().nextDouble() > sampleRate;
    }

    abstract class StatsDMessage<T extends Number>
    extends NumericMessage<T> {
        final double sampleRate;
        final /* synthetic */ NonBlockingStatsDClient this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected StatsDMessage(String value, Message.Type sampleRate, T t, double tags, String[] stringArray) {
            void aspect;
            this.this$0 = (NonBlockingStatsDClient)this$0;
            super((String)aspect, (Message.Type)type, value, (String[])tags);
            this.sampleRate = sampleRate;
        }

        @Override
        public final void writeTo(StringBuilder builder) {
            builder.append(this.this$0.prefix).append(this.aspect).append(':');
            this.writeValue(builder);
            builder.append('|').append((Object)this.type);
            if (!Double.isNaN(this.sampleRate)) {
                builder.append('|').append('@').append(NonBlockingStatsDClient.format(SAMPLE_RATE_FORMATTER, this.sampleRate));
            }
            this.this$0.tagString(this.tags, builder);
            builder.append('\n');
        }

        protected abstract void writeValue(StringBuilder var1);
    }

    static enum Literal {
        SERVICE,
        ENV,
        VERSION;

        private static final String PREFIX = "dd";

        String envName() {
            return ("dd_" + this.toString()).toUpperCase();
        }

        String envVal() {
            return System.getenv(this.envName());
        }

        String tag() {
            return this.toString().toLowerCase();
        }
    }
}

