/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class BufferPool {
    private final BlockingQueue<ByteBuffer> pool;
    private final int size;
    private final int bufferSize;
    private final boolean direct;

    BufferPool(int poolSize, int bufferSize, boolean direct) throws InterruptedException {
        this.size = poolSize;
        this.bufferSize = bufferSize;
        this.direct = direct;
        this.pool = new ArrayBlockingQueue<ByteBuffer>(poolSize);
        for (int i = 0; i < this.size; ++i) {
            if (direct) {
                this.pool.put(ByteBuffer.allocateDirect(bufferSize));
                continue;
            }
            this.pool.put(ByteBuffer.allocate(bufferSize));
        }
    }

    BufferPool(BufferPool pool) throws InterruptedException {
        this.size = pool.size;
        this.bufferSize = pool.bufferSize;
        this.direct = pool.direct;
        this.pool = new ArrayBlockingQueue<ByteBuffer>(pool.size);
        for (int i = 0; i < this.size; ++i) {
            if (this.direct) {
                this.pool.put(ByteBuffer.allocateDirect(this.bufferSize));
                continue;
            }
            this.pool.put(ByteBuffer.allocate(this.bufferSize));
        }
    }

    ByteBuffer borrow() throws InterruptedException {
        return this.pool.take();
    }

    void put(ByteBuffer buffer) throws InterruptedException {
        this.pool.put(buffer);
    }

    int getSize() {
        return this.size;
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    int available() {
        return this.pool.size();
    }
}

