/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

public class ServiceCheck {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int CRITICAL = 2;
    public static final int UNKNOWN = 3;
    private String name;
    private String hostname;
    private String message;
    private int status;
    private int checkRunId;
    private int timestamp;
    private String[] tags;

    public ServiceCheck() {
    }

    public ServiceCheck(String name, int status) {
        this(name, status, null, null, null);
    }

    public ServiceCheck(String name, int status, String message, String[] tags) {
        this(name, status, message, null, tags);
    }

    public ServiceCheck(String name, int status, String message, String hostname, String[] tags) {
        this.name = name;
        this.status = status;
        this.message = message;
        this.hostname = hostname;
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getEscapedMessage() {
        return this.message.replace("\n", "\\n").replace("m:", "m\\:");
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String ... tags) {
        this.tags = tags;
    }

    public String toStatsDString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("_sc|%s|%d", this.name, this.status));
        if (this.timestamp > 0) {
            sb.append(String.format("|d:%d", this.timestamp));
        }
        if (this.hostname != null) {
            sb.append(String.format("|h:%s", this.hostname));
        }
        if (this.tags != null && this.tags.length > 0) {
            sb.append(String.format("|#%s", this.tags[0]));
            for (int i = 1; i < this.tags.length; ++i) {
                sb.append(',').append(this.tags[i]);
            }
        }
        if (this.message != null) {
            sb.append(String.format("|m:%s", this.getEscapedMessage()));
        }
        return sb.toString();
    }
}

