/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation.ptags;

import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.cache.DDPartialKeyCache;
import ddtrot.dd.trace.core.propagation.ptags.TagElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TagKey
extends TagElement {
    private static final Logger log = LoggerFactory.getLogger(TagKey.class);
    private static final DDPartialKeyCache<String, TagKey> keyCache = DDCaches.newFixedSizePartialKeyCache(64);
    private final String none;
    private final String[] keys = new String[TagElement.Encoding.getNumValues()];

    static TagKey from(String s) {
        if (s == null || TagKey.isHeaderInvalid(s, 0, s.length(), null)) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid header s: {}", (Object)s);
            }
            return null;
        }
        return keyCache.computeIfAbsent(s, 0, s.length(), TagKey::hash, TagKey::compare, TagKey::produce);
    }

    static TagKey from(TagElement.Encoding encoding, String s) {
        if (TagKey.isHeaderInvalid(encoding, s)) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid header h: {} s: {}", (Object)encoding, (Object)s);
            }
            return null;
        }
        int pl = encoding.getPrefixLength();
        return keyCache.computeIfAbsent(s, pl, s.length(), TagKey::hash, TagKey::compare, TagKey::produce);
    }

    static TagKey from(TagElement.Encoding encoding, String s, int start, int end) {
        if (TagKey.isHeaderInvalid(encoding, s, start, end)) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid header h: {} s: {} b: {} e: {}", new Object[]{encoding, s, start, end});
            }
            return null;
        }
        int pl = encoding.getPrefixLength();
        return keyCache.computeIfAbsent(s, start + pl, end, TagKey::hash, TagKey::compare, TagKey::produce);
    }

    private static boolean isHeaderInvalid(TagElement.Encoding encoding, String s) {
        if (encoding == null || s == null) {
            return true;
        }
        return TagKey.isHeaderInvalid(encoding, s, 0, s.length());
    }

    private static boolean isHeaderInvalid(TagElement.Encoding encoding, String s, int start, int end) {
        if (encoding == null || s == null) {
            return true;
        }
        return TagKey.isHeaderInvalid(s, start, end, encoding.getPrefix());
    }

    private static boolean isHeaderInvalid(String s, int start, int end, String prefix) {
        int pl = prefix == null ? 0 : prefix.length();
        int sl = s.length();
        return start < 0 || end <= 0 || end - start <= pl || sl <= pl || sl < end || prefix != null && !s.startsWith(prefix, start);
    }

    private static int hash(String s, int start, int end) {
        int h = 0;
        end = Integer.min(s.length(), end);
        if (start >= 0 && end > 0) {
            for (int i = start; i < end; ++i) {
                h = 31 * h + s.charAt(i);
            }
        }
        return h;
    }

    private static boolean compare(String s, int start, int end, TagKey tagKey) {
        end = Integer.min(s.length(), end);
        if (start < 0 || end < 0 || end - start != tagKey.length()) {
            return false;
        }
        boolean eq = true;
        int i = start;
        int j = 0;
        while (eq && i < end) {
            eq = s.charAt(i) == tagKey.charAt(j);
            ++i;
            ++j;
        }
        return eq;
    }

    private static TagKey produce(String s, int hash, int start, int end) {
        return new TagKey(s, start, end);
    }

    TagKey(String s, int start, int end) {
        this.none = start == 0 && end == s.length() ? s : s.substring(start, end);
        for (TagElement.Encoding p : TagElement.Encoding.getCachedValues()) {
            this.keys[p.ordinal()] = p.getPrefix() + this.none;
        }
    }

    @Override
    CharSequence forType(TagElement.Encoding encoding) {
        return this.keys[encoding.ordinal()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagKey tagKey = (TagKey)o;
        return this.none.equals(tagKey.none);
    }

    public int hashCode() {
        return this.none.hashCode();
    }

    @Override
    public String toString() {
        return this.none;
    }

    @Override
    public int length() {
        return this.none.length();
    }

    @Override
    public char charAt(int index) {
        return this.none.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.none.subSequence(start, end);
    }
}

