/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.rum;

import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.rum.RumInjector;
import ddtrot.dd.trace.api.rum.RumInjectorConfig;
import ddtrot.dd.trace.api.rum.RumTelemetryCollector;
import java.util.concurrent.atomic.AtomicLong;

public class RumInjectorMetrics
implements RumTelemetryCollector {
    private final AtomicLong injectionSucceed = new AtomicLong();
    private final AtomicLong injectionFailed = new AtomicLong();
    private final AtomicLong injectionSkipped = new AtomicLong();
    private final AtomicLong contentSecurityPolicyDetected = new AtomicLong();
    private final AtomicLong initializationSucceed = new AtomicLong();
    private final StatsDClient statsd;
    private final String applicationId;
    private final String remoteConfigUsed;
    private final DDCache<String, String[]> succeedTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, String[]> skippedTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, String[]> cspTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, String[]> responseTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, String[]> timeTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, String[]> failedTagsCache = DDCaches.newFixedSizeCache(16);
    private static final String[] INIT_TAGS = new String[]{"integration_name:servlet", "integration_version:N/A"};

    public RumInjectorMetrics(StatsDClient statsd) {
        this.statsd = statsd;
        RumInjector rumInjector = RumInjector.get();
        RumInjectorConfig injectorConfig = Config.get().getRumInjectorConfig();
        if (rumInjector.isEnabled() && injectorConfig != null) {
            this.applicationId = injectorConfig.applicationId;
            this.remoteConfigUsed = injectorConfig.remoteConfigurationId != null ? "true" : "false";
        } else {
            this.applicationId = "unknown";
            this.remoteConfigUsed = "false";
        }
    }

    @Override
    public void onInjectionSucceed(String servletVersion) {
        this.injectionSucceed.incrementAndGet();
        String[] tags = this.succeedTagsCache.computeIfAbsent(servletVersion, version -> new String[]{"application_id:" + this.applicationId, "integration_name:servlet", "integration_version:" + version, "remote_config_used:" + this.remoteConfigUsed});
        this.statsd.count("rum.injection.succeed", 1L, tags);
    }

    @Override
    public void onInjectionFailed(String servletVersion, String contentEncoding) {
        this.injectionFailed.incrementAndGet();
        String cacheKey = servletVersion + ":" + contentEncoding;
        String[] tags = this.failedTagsCache.computeIfAbsent(cacheKey, key -> {
            if (contentEncoding != null) {
                return new String[]{"application_id:" + this.applicationId, "content_encoding:" + contentEncoding, "integration_name:servlet", "integration_version:" + servletVersion, "reason:failed_to_return_response_wrapper", "remote_config_used:" + this.remoteConfigUsed};
            }
            return new String[]{"application_id:" + this.applicationId, "integration_name:servlet", "integration_version:" + servletVersion, "reason:failed_to_return_response_wrapper", "remote_config_used:" + this.remoteConfigUsed};
        });
        this.statsd.count("rum.injection.failed", 1L, tags);
    }

    @Override
    public void onInjectionSkipped(String servletVersion) {
        this.injectionSkipped.incrementAndGet();
        String[] tags = this.skippedTagsCache.computeIfAbsent(servletVersion, version -> new String[]{"application_id:" + this.applicationId, "integration_name:servlet", "integration_version:" + version, "reason:should_not_inject", "remote_config_used:" + this.remoteConfigUsed});
        this.statsd.count("rum.injection.skipped", 1L, tags);
    }

    @Override
    public void onInitializationSucceed() {
        this.initializationSucceed.incrementAndGet();
        this.statsd.count("rum.injection.initialization.succeed", 1L, INIT_TAGS);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onContentSecurityPolicyDetected(String servletVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onInjectionResponseSize(String servletVersion, long bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onInjectionTime(String servletVersion, long milliseconds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        this.injectionSucceed.set(0L);
        this.injectionFailed.set(0L);
        this.injectionSkipped.set(0L);
        this.contentSecurityPolicyDetected.set(0L);
        this.initializationSucceed.set(0L);
        this.succeedTagsCache.clear();
        this.skippedTagsCache.clear();
        this.cspTagsCache.clear();
        this.responseTagsCache.clear();
        this.timeTagsCache.clear();
        this.failedTagsCache.clear();
    }

    @Override
    public String summary() {
        return "\ninitializationSucceed=" + this.initializationSucceed.get() + "\ninjectionSucceed=" + this.injectionSucceed.get() + "\ninjectionFailed=" + this.injectionFailed.get() + "\ninjectionSkipped=" + this.injectionSkipped.get() + "\ncontentSecurityPolicyDetected=" + this.contentSecurityPolicyDetected.get();
    }
}

