/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v1;

import ddtrot.dd.trace.api.naming.NamingSchema;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MessagingNamingV1
implements NamingSchema.ForMessaging {
    private static final Supplier<String> NULL_SUPPLIER = () -> null;

    private String normalizeForCloud(@Nonnull String messagingSystem) {
        switch (messagingSystem) {
            case "sns": 
            case "sqs": {
                return "aws." + messagingSystem;
            }
            case "google-pubsub": {
                return "gcp.pubsub";
            }
        }
        return messagingSystem;
    }

    @Override
    @Nonnull
    public String outboundOperation(@Nonnull String messagingSystem) {
        return this.normalizeForCloud(messagingSystem) + ".send";
    }

    @Override
    public Supplier<String> outboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        return NULL_SUPPLIER;
    }

    @Override
    @Nonnull
    public String inboundOperation(@Nonnull String messagingSystem) {
        return this.normalizeForCloud(messagingSystem) + ".process";
    }

    @Override
    public Supplier<String> inboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        return NULL_SUPPLIER;
    }

    @Override
    @Nonnull
    public Supplier<String> timeInQueueService(@Nonnull String messagingSystem) {
        return () -> messagingSystem + "-queue";
    }

    @Override
    @Nonnull
    public String timeInQueueOperation(@Nonnull String messagingSystem) {
        return this.normalizeForCloud(messagingSystem) + ".deliver";
    }
}

