/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.telemetry.tag;

import ddtrot.dd.trace.api.civisibility.telemetry.TagValue;
import javax.annotation.Nullable;

public enum StatusCode implements TagValue
{
    BAD_REQUEST(400),
    UNAUTHORIZED(401),
    FORBIDDEN(403),
    NOT_FOUND(404),
    REQUEST_TIMEOUT(408),
    TOO_MANY_REQUESTS(429);

    private final String s;

    private StatusCode(int code) {
        this.s = "status_code:" + code;
    }

    @Override
    public String asString() {
        return this.s;
    }

    @Nullable
    public static StatusCode from(int responseCode) {
        switch (responseCode) {
            case 400: {
                return BAD_REQUEST;
            }
            case 401: {
                return UNAUTHORIZED;
            }
            case 403: {
                return FORBIDDEN;
            }
            case 404: {
                return NOT_FOUND;
            }
            case 408: {
                return REQUEST_TIMEOUT;
            }
            case 429: {
                return TOO_MANY_REQUESTS;
            }
        }
        return null;
    }
}

