/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch;

import ddtrot.com.datadoghq.sketch.QuantileSketch;
import ddtrot.com.datadoghq.sketch.ddsketch.DDSketches;
import ddtrot.com.datadoghq.sketch.ddsketch.Serializer;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.BinEncodingMode;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Flag;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Input;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.MalformedInputException;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Output;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.VarEncodingHelper;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.IndexMappingConverter;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.store.Bin;
import ddtrot.com.datadoghq.sketch.ddsketch.store.CollapsingHighestDenseStore;
import ddtrot.com.datadoghq.sketch.ddsketch.store.CollapsingLowestDenseStore;
import ddtrot.com.datadoghq.sketch.ddsketch.store.Store;
import ddtrot.com.datadoghq.sketch.ddsketch.store.UnboundedSizeDenseStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;

public class DDSketch
implements QuantileSketch<DDSketch> {
    private final IndexMapping indexMapping;
    private final double minIndexedValue;
    private final double maxIndexedValue;
    private final Store negativeValueStore;
    private final Store positiveValueStore;
    private double zeroCount;

    private DDSketch(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount, double minIndexedValue) {
        this.indexMapping = indexMapping;
        this.minIndexedValue = Math.max(minIndexedValue, indexMapping.minIndexableValue());
        this.maxIndexedValue = indexMapping.maxIndexableValue();
        this.negativeValueStore = negativeValueStore;
        this.positiveValueStore = positiveValueStore;
        this.zeroCount = zeroCount;
    }

    DDSketch(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount) {
        this(indexMapping, negativeValueStore, positiveValueStore, zeroCount, 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> storeSupplier) {
        this(indexMapping, storeSupplier, storeSupplier, 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier) {
        this(indexMapping, negativeValueStoreSupplier.get(), positiveValueStoreSupplier.get(), 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier, double minIndexedValue) {
        this(indexMapping, negativeValueStoreSupplier.get(), positiveValueStoreSupplier.get(), 0.0, minIndexedValue);
    }

    public DDSketch(double relativeAccuracy) {
        this(new LogarithmicMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    private DDSketch(DDSketch sketch) {
        this.indexMapping = sketch.indexMapping;
        this.minIndexedValue = sketch.minIndexedValue;
        this.maxIndexedValue = sketch.maxIndexedValue;
        this.negativeValueStore = sketch.negativeValueStore.copy();
        this.positiveValueStore = sketch.positiveValueStore.copy();
        this.zeroCount = sketch.zeroCount;
    }

    public static DDSketch of(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount) {
        if (!(zeroCount >= 0.0)) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        return new DDSketch(Objects.requireNonNull(indexMapping), Objects.requireNonNull(negativeValueStore), Objects.requireNonNull(positiveValueStore), zeroCount);
    }

    public IndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public Store getNegativeValueStore() {
        return this.negativeValueStore;
    }

    public Store getPositiveValueStore() {
        return this.positiveValueStore;
    }

    @Override
    public void accept(double value) {
        this.checkValueTrackable(value);
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value));
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value));
        } else {
            this.zeroCount += 1.0;
        }
    }

    @Override
    public void accept(double value, double count) {
        this.checkValueTrackable(value);
        if (count < 0.0) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value), count);
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value), count);
        } else {
            this.zeroCount += count;
        }
    }

    private void checkValueTrackable(double value) {
        if (value < -this.maxIndexedValue || value > this.maxIndexedValue) {
            throw new IllegalArgumentException("The input value is outside the range that is tracked by the sketch.");
        }
    }

    @Override
    public void mergeWith(DDSketch other) {
        DDSketch.checkMergeability(this.indexMapping, other.indexMapping);
        this.negativeValueStore.mergeWith(other.negativeValueStore);
        this.positiveValueStore.mergeWith(other.positiveValueStore);
        this.zeroCount += other.zeroCount;
    }

    private static void checkMergeability(IndexMapping indexMapping1, IndexMapping indexMapping2) throws IllegalArgumentException {
        if (!indexMapping1.equals(indexMapping2)) {
            throw new IllegalArgumentException("The sketches are not mergeable because they do not use the same index mappings.");
        }
    }

    @Override
    public DDSketch copy() {
        return new DDSketch(this);
    }

    @Override
    public boolean isEmpty() {
        return this.zeroCount == 0.0 && this.negativeValueStore.isEmpty() && this.positiveValueStore.isEmpty();
    }

    @Override
    public void clear() {
        this.negativeValueStore.clear();
        this.positiveValueStore.clear();
        this.zeroCount = 0.0;
    }

    @Override
    public double getCount() {
        return this.zeroCount + this.negativeValueStore.getTotalCount() + this.positiveValueStore.getTotalCount();
    }

    @Override
    public double getSum() {
        double[] sum = new double[]{0.0};
        this.negativeValueStore.forEach((index, count) -> {
            sum[0] = sum[0] - this.indexMapping.value(index) * count;
        });
        this.positiveValueStore.forEach((index, count) -> {
            sum[0] = sum[0] + this.indexMapping.value(index) * count;
        });
        return sum[0];
    }

    @Override
    public double getMinValue() {
        if (!this.negativeValueStore.isEmpty()) {
            return -this.indexMapping.value(this.negativeValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0.0) {
            return 0.0;
        }
        return this.indexMapping.value(this.positiveValueStore.getMinIndex());
    }

    @Override
    public double getMaxValue() {
        if (!this.positiveValueStore.isEmpty()) {
            return this.indexMapping.value(this.positiveValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0.0) {
            return 0.0;
        }
        return -this.indexMapping.value(this.negativeValueStore.getMinIndex());
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        return this.getValueAtQuantile(quantile, this.getCount());
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        double count = this.getCount();
        return Arrays.stream(quantiles).map(quantile -> this.getValueAtQuantile(quantile, count)).toArray();
    }

    private double getValueAtQuantile(double quantile, double count) {
        double d;
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("The quantile must be between 0 and 1.");
        }
        if (count == 0.0) {
            throw new NoSuchElementException();
        }
        double rank = quantile * (count - 1.0);
        double n = 0.0;
        Iterator<Bin> negativeBinIterator = this.negativeValueStore.getDescendingIterator();
        while (negativeBinIterator.hasNext()) {
            double d2;
            Bin bin = negativeBinIterator.next();
            n += bin.getCount();
            if (!(d2 > rank)) continue;
            return -this.indexMapping.value(bin.getIndex());
        }
        n += this.zeroCount;
        if (d > rank) {
            return 0.0;
        }
        Iterator<Bin> positiveBinIterator = this.positiveValueStore.getAscendingIterator();
        while (positiveBinIterator.hasNext()) {
            double d3;
            Bin bin = positiveBinIterator.next();
            n += bin.getCount();
            if (!(d3 > rank)) continue;
            return this.indexMapping.value(bin.getIndex());
        }
        throw new NoSuchElementException();
    }

    public DDSketch convert(IndexMapping newIndexMapping, Supplier<Store> storeSupplier) {
        IndexMappingConverter indexMappingConverter = IndexMappingConverter.distributingUniformly(this.indexMapping, newIndexMapping);
        Store newNegativeValueStore = storeSupplier.get();
        indexMappingConverter.convertAscendingIterator(this.negativeValueStore.getAscendingIterator(), newNegativeValueStore::add);
        Store newPositiveValueStore = storeSupplier.get();
        indexMappingConverter.convertAscendingIterator(this.positiveValueStore.getAscendingIterator(), newPositiveValueStore::add);
        return new DDSketch(newIndexMapping, newNegativeValueStore, newPositiveValueStore, this.zeroCount, this.minIndexedValue);
    }

    public void encode(Output output, boolean omitIndexMapping) throws IOException {
        if (!omitIndexMapping) {
            this.indexMapping.encode(output);
        }
        if (this.zeroCount != 0.0) {
            Flag.ZERO_COUNT.encode(output);
            VarEncodingHelper.encodeVarDouble(output, this.zeroCount);
        }
        this.positiveValueStore.encode(output, Flag.Type.POSITIVE_STORE);
        this.negativeValueStore.encode(output, Flag.Type.NEGATIVE_STORE);
    }

    public void decodeAndMergeWith(Input input) throws IOException {
        this.decodeAndMergeWith(input, DDSketch::ignoreExactSummaryStatisticFlags);
    }

    void decodeAndMergeWith(Input input, Decoder fallback) throws IOException {
        DecodingState state = new DecodingState(this.indexMapping, this.negativeValueStore, this.positiveValueStore, this.zeroCount);
        DDSketch.decodeAndMergeWith(state, input, fallback);
        this.zeroCount = state.zeroCount;
    }

    public static DDSketch decode(Input input, Supplier<Store> storeSupplier) throws IOException {
        return DDSketch.decode(input, storeSupplier, null);
    }

    public static DDSketch decode(Input input, Supplier<Store> storeSupplier, IndexMapping indexMapping) throws IOException {
        return DDSketch.decode(input, storeSupplier, indexMapping, DDSketch::ignoreExactSummaryStatisticFlags);
    }

    public static DDSketch decode(Input input, Supplier<Store> storeSupplier, IndexMapping indexMapping, Decoder fallback) throws IOException {
        DecodingState state = new DecodingState(indexMapping, storeSupplier.get(), storeSupplier.get(), 0.0);
        DDSketch.decodeAndMergeWith(state, input, fallback);
        if (state.indexMapping == null) {
            throw new IllegalArgumentException("The index mapping is missing.");
        }
        return new DDSketch(state.indexMapping, state.negativeValueStore, state.positiveValueStore, state.zeroCount);
    }

    private static void decodeAndMergeWith(DecodingState state, Input input, Decoder fallback) throws IOException {
        block6: while (input.hasRemaining()) {
            Flag flag = Flag.decode(input);
            switch (flag.type()) {
                case POSITIVE_STORE: {
                    state.positiveValueStore.decodeAndMergeWith(input, BinEncodingMode.ofFlag(flag));
                    continue block6;
                }
                case NEGATIVE_STORE: {
                    state.negativeValueStore.decodeAndMergeWith(input, BinEncodingMode.ofFlag(flag));
                    continue block6;
                }
                case INDEX_MAPPING: {
                    IndexMapping decodedIndexMapping = IndexMapping.decode(input, IndexMappingLayout.ofFlag(flag));
                    if (state.indexMapping == null) {
                        state.indexMapping = decodedIndexMapping;
                        continue block6;
                    }
                    DDSketch.checkMergeability(state.indexMapping, decodedIndexMapping);
                    continue block6;
                }
                case SKETCH_FEATURES: {
                    if (Flag.ZERO_COUNT.equals(flag)) {
                        DecodingState decodingState = state;
                        decodingState.zeroCount = decodingState.zeroCount + VarEncodingHelper.decodeVarDouble(input);
                        continue block6;
                    }
                    fallback.decode(input, flag);
                    continue block6;
                }
            }
            throw new MalformedInputException("The flag type is invalid.");
        }
    }

    static void ignoreExactSummaryStatisticFlags(Input input, Flag flag) throws IOException {
        if (Flag.COUNT.equals(flag)) {
            VarEncodingHelper.decodeVarDouble(input);
        } else if (Flag.SUM.equals(flag) || Flag.MIN.equals(flag) || Flag.MAX.equals(flag)) {
            input.readDoubleLE();
        } else {
            DDSketch.throwInvalidFlagException(input, flag);
        }
    }

    static void throwInvalidFlagException(Input input, Flag flag) throws IOException {
        throw new MalformedInputException("The flag is invalid.");
    }

    public int serializedSize() {
        return Serializer.embeddedFieldSize(1, this.indexMapping.serializedSize()) + Serializer.embeddedFieldSize(2, this.positiveValueStore.serializedSize()) + Serializer.embeddedFieldSize(3, this.negativeValueStore.serializedSize()) + Serializer.doubleFieldSize(4, this.zeroCount);
    }

    public ByteBuffer serialize() {
        int indexMappingSize = this.indexMapping.serializedSize();
        int positiveValueStoreSize = this.positiveValueStore.serializedSize();
        int negativeValueStoreSize = this.negativeValueStore.serializedSize();
        int totalSize = Serializer.embeddedFieldSize(1, indexMappingSize) + Serializer.embeddedFieldSize(2, positiveValueStoreSize) + Serializer.embeddedFieldSize(3, negativeValueStoreSize) + Serializer.doubleFieldSize(4, this.zeroCount);
        Serializer serializer = new Serializer(totalSize);
        serializer.writeHeader(1, indexMappingSize);
        this.indexMapping.serialize(serializer);
        serializer.writeHeader(2, positiveValueStoreSize);
        this.positiveValueStore.serialize(serializer);
        serializer.writeHeader(3, negativeValueStoreSize);
        this.negativeValueStore.serialize(serializer);
        serializer.writeDouble(4, this.zeroCount);
        return serializer.getBuffer();
    }

    double getZeroCount() {
        return this.zeroCount;
    }

    @Deprecated
    public static DDSketch balanced(double relativeAccuracy) {
        return DDSketches.unboundedDense(relativeAccuracy);
    }

    @Deprecated
    public static DDSketch balancedCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.collapsingLowestDense(relativeAccuracy, maxNumBins);
    }

    @Deprecated
    public static DDSketch balancedCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.collapsingHighestDense(relativeAccuracy, maxNumBins);
    }

    @Deprecated
    public static DDSketch fast(double relativeAccuracy) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    @Deprecated
    public static DDSketch fastCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    @Deprecated
    public static DDSketch fastCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }

    @Deprecated
    public static DDSketch memoryOptimal(double relativeAccuracy) {
        return DDSketches.logarithmicUnboundedDense(relativeAccuracy);
    }

    @Deprecated
    public static DDSketch memoryOptimalCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.logarithmicCollapsingLowestDense(relativeAccuracy, maxNumBins);
    }

    @Deprecated
    public static DDSketch memoryOptimalCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.logarithmicCollapsingHighestDense(relativeAccuracy, maxNumBins);
    }

    private static final class DecodingState {
        private IndexMapping indexMapping;
        private final Store negativeValueStore;
        private final Store positiveValueStore;
        private double zeroCount;

        private DecodingState(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount) {
            this.indexMapping = indexMapping;
            this.negativeValueStore = negativeValueStore;
            this.positiveValueStore = positiveValueStore;
            this.zeroCount = zeroCount;
        }
    }

    static interface Decoder {
        public void decode(Input var1, Flag var2) throws IOException;
    }
}

