/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.profiling;

import datadog.trace.api.profiling.Profiling;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProfilingEnablement {
    ENABLED(true, "manual"),
    DISABLED(false),
    AUTO(true),
    INJECTED(true);

    private static final Logger logger;
    private final boolean active;
    private final String alias;

    private ProfilingEnablement(boolean active) {
        this.active = active;
        this.alias = this.name().toLowerCase();
    }

    private ProfilingEnablement(boolean active, String alias) {
        this.active = active;
        this.alias = alias;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getAlias() {
        return this.alias;
    }

    public static ProfilingEnablement from(ConfigProvider config) {
        ProfilingEnablement ret = DISABLED;
        String value = config.getString("profiling.enabled");
        if (value != null) {
            ret = ProfilingEnablement.of(value);
        }
        if (ret == DISABLED) {
            String ssi = config.getString("injection.enabled");
            ret = ssi != null && ssi.contains("profiler") ? INJECTED : DISABLED;
        }
        return ret;
    }

    public static ProfilingEnablement of(String value) {
        if (value == null) {
            return DISABLED;
        }
        switch (value.toLowerCase()) {
            case "true": 
            case "1": {
                return ENABLED;
            }
            case "auto": {
                return AUTO;
            }
        }
        return DISABLED;
    }

    public static void validate(String value) {
        if (value == null) {
            return;
        }
        switch (value.toLowerCase()) {
            case "false": 
            case "true": 
            case "auto": {
                return;
            }
            case "1": 
            case "0": {
                return;
            }
        }
        logger.warn("Invalid value for 'dd.profiling.enabled' (DD_PROFILING_ENABLED) detected: {}. Valid values are 'true', 'false' and 'auto'.", (Object)value);
    }

    static {
        logger = LoggerFactory.getLogger(Profiling.class);
    }
}

