/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.internal.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class LongStringUtils {
    private static final long MAX_FIRST_PART = 0x1999999999999999L;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private LongStringUtils() {
    }

    public static long parseUnsignedLongHex(CharSequence s) throws NumberFormatException {
        return LongStringUtils.parseUnsignedLongHex(s, 0, s == null ? 0 : s.length(), false);
    }

    public static long parseUnsignedLongHex(CharSequence s, int start, int len, boolean lowerCaseOnly) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (len > 0 && start >= 0 && start + len <= s.length()) {
            if (len > 16 && len - LongStringUtils.firstNonZeroCharacter(s, start) > 16) {
                throw LongStringUtils.numberFormatOutOfLongRange(s);
            }
            long result = 0L;
            int ok = 0;
            int i = 0;
            while (i < len && ok >= 0) {
                char c = s.charAt(start);
                int d = Character.digit(c, 16);
                if (lowerCaseOnly && Character.isUpperCase(c)) {
                    ok = -1;
                }
                ok |= d;
                result = result << 4 | (long)d;
                ++i;
                ++start;
            }
            if (ok < 0) {
                throw new NumberFormatException("Illegal character in " + s.subSequence(start, len));
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static int firstNonZeroCharacter(CharSequence s, int start) {
        int firstNonZero;
        for (firstNonZero = start; firstNonZero < s.length() && s.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        return firstNonZero;
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("s can't be null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 18) {
                return Long.parseLong(s);
            }
            if (len > 20) {
                throw LongStringUtils.numberFormatOutOfLongRange(s);
            }
            long first = 0L;
            int ok = 0;
            for (int i = 0; i < len - 1; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 10);
                ok |= d;
                first = first * 10L + (long)d;
            }
            int last = Character.digit(s.charAt(len - 1), 10);
            if ((ok |= last) < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            if (first > 0x1999999999999999L) {
                throw LongStringUtils.numberFormatOutOfLongRange(s);
            }
            long guard = first * 10L;
            long result = guard + (long)last;
            if (guard < 0L && result >= 0L) {
                throw LongStringUtils.numberFormatOutOfLongRange(s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    public static NumberFormatException numberFormatOutOfLongRange(CharSequence s) {
        return new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    public static String toHexStringPadded(long id, int size) {
        byte[] bytes = LongStringUtils.allocatePaddedHexStringBytes(size);
        LongStringUtils.fillStringBytesWithPaddedHexId(id, 0, bytes.length, bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static String toHexStringPadded(long highOrderBits, long lowOrderBits, int size) {
        if (size <= 16) {
            return LongStringUtils.toHexStringPadded(lowOrderBits, size);
        }
        byte[] bytes = LongStringUtils.allocatePaddedHexStringBytes(size);
        LongStringUtils.fillStringBytesWithPaddedHexId(highOrderBits, 0, 16, bytes);
        LongStringUtils.fillStringBytesWithPaddedHexId(lowOrderBits, 16, 16, bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private static byte[] allocatePaddedHexStringBytes(int size) {
        if (size > 16) {
            size = 32;
        } else if (size < 16) {
            size = 16;
        }
        return new byte[size];
    }

    private static void fillStringBytesWithPaddedHexId(long id, int index, int size, byte[] bytes) {
        int nibbleCount = Long.numberOfLeadingZeros(id) >>> 2;
        Arrays.fill(bytes, index, index + (size - 16) + nibbleCount, (byte)48);
        for (int i = 0; i < 16 - nibbleCount; ++i) {
            int b = (int)(id & 0xFL);
            bytes[index + size - 1 - i] = HEX_DIGITS[b];
            id >>>= 4;
        }
    }
}

