/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.trace.api.time.SystemTimeSource;
import datadog.trace.api.time.TimeSource;
import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class OtelSpanEvent {
    public static final String EXCEPTION_SPAN_EVENT_NAME = "exception";
    public static final AttributeKey<String> EXCEPTION_MESSAGE_ATTRIBUTE_KEY = AttributeKey.stringKey("exception.message");
    public static final AttributeKey<String> EXCEPTION_TYPE_ATTRIBUTE_KEY = AttributeKey.stringKey("exception.type");
    public static final AttributeKey<String> EXCEPTION_STACK_TRACE_ATTRIBUTE_KEY = AttributeKey.stringKey("exception.stacktrace");
    private static TimeSource timeSource = SystemTimeSource.INSTANCE;
    private final String name;
    private final String attributes;
    private final long timestamp;

    public OtelSpanEvent(String name, Attributes attributes) {
        this.name = name;
        this.attributes = AttributesJsonParser.toJson(attributes);
        this.timestamp = timeSource.getCurrentTimeNanos();
    }

    public OtelSpanEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        this.name = name;
        this.attributes = AttributesJsonParser.toJson(attributes);
        this.timestamp = unit.toNanos(timestamp);
    }

    @NonNull
    public static String toTag(List<OtelSpanEvent> events) {
        StringBuilder builder = new StringBuilder("[");
        for (OtelSpanEvent event : events) {
            if (builder.length() > 1) {
                builder.append(',');
            }
            builder.append(event.toJson());
        }
        return builder.append(']').toString();
    }

    static Attributes initializeExceptionAttributes(Throwable exception, Attributes additionalAttributes) {
        AttributesBuilder builder = additionalAttributes.toBuilder();
        String value = additionalAttributes.get(EXCEPTION_MESSAGE_ATTRIBUTE_KEY);
        if (value == null) {
            value = exception.getMessage();
            builder.put(EXCEPTION_MESSAGE_ATTRIBUTE_KEY, value);
        }
        if ((value = additionalAttributes.get(EXCEPTION_TYPE_ATTRIBUTE_KEY)) == null) {
            value = exception.getClass().getName();
            builder.put(EXCEPTION_TYPE_ATTRIBUTE_KEY, value);
        }
        if ((value = additionalAttributes.get(EXCEPTION_STACK_TRACE_ATTRIBUTE_KEY)) == null) {
            value = OtelSpanEvent.stringifyErrorStack(exception);
            builder.put(EXCEPTION_STACK_TRACE_ATTRIBUTE_KEY, value);
        }
        return builder.build();
    }

    static String stringifyErrorStack(Throwable error) {
        StringWriter errorString = new StringWriter();
        error.printStackTrace(new PrintWriter(errorString));
        return errorString.toString();
    }

    public static void setTimeSource(TimeSource newTimeSource) {
        timeSource = newTimeSource;
    }

    public String toJson() {
        StringBuilder builder = new StringBuilder("{\"time_unix_nano\":" + this.timestamp + ",\"name\":\"" + this.name + "\"");
        if (!this.attributes.isEmpty()) {
            builder.append(",\"attributes\":").append(this.attributes);
        }
        return builder.append('}').toString();
    }

    public String toString() {
        return "OtelSpanEvent{timestamp=" + this.timestamp + ", name='" + this.name + "', attributes='" + this.attributes + "'}";
    }

    public static class AttributesJsonParser {
        public static String toJson(Attributes attributes) {
            if (attributes == null || attributes.isEmpty()) {
                return "";
            }
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append('{');
            Set<Map.Entry<AttributeKey<?>, Object>> entrySet = attributes.asMap().entrySet();
            for (Map.Entry<AttributeKey<?>, Object> entry : entrySet) {
                if (jsonBuilder.length() > 1) {
                    jsonBuilder.append(',');
                }
                String key = entry.getKey().getKey();
                Object value = entry.getValue();
                jsonBuilder.append('\"').append(AttributesJsonParser.escapeJson(key)).append("\":");
                AttributesJsonParser.appendValue(value, jsonBuilder);
            }
            jsonBuilder.append('}');
            return jsonBuilder.toString();
        }

        private static void appendValue(Object value, StringBuilder jsonBuilder) {
            if (value instanceof String) {
                jsonBuilder.append('\"').append(AttributesJsonParser.escapeJson((String)value)).append('\"');
            } else if (value instanceof List) {
                jsonBuilder.append('[');
                List valArray = (List)value;
                for (int i = 0; i < valArray.size(); ++i) {
                    if (i > 0) {
                        jsonBuilder.append(',');
                    }
                    AttributesJsonParser.appendValue(valArray.get(i), jsonBuilder);
                }
                jsonBuilder.append(']');
            } else if (value instanceof Number || value instanceof Boolean) {
                jsonBuilder.append(value);
            } else {
                jsonBuilder.append("null");
            }
        }

        private static String escapeJson(String value) {
            return value.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        }
    }
}

