/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongCounter;
import datadog.trace.bootstrap.otel.api.metrics.LongCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.ObservableLongCounter;
import datadog.trace.bootstrap.otel.api.metrics.ObservableLongMeasurement;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.metrics.OtelDoubleCounter;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentBuilder;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentType;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelLongCounter
implements LongCounter {
    OtelLongCounter() {
    }

    @Override
    public void add(long value) {
    }

    @Override
    public void add(long value, Attributes attributes) {
    }

    @Override
    public void add(long value, Attributes attributes, Context context) {
    }

    static final class Builder
    implements LongCounterBuilder {
        private final OtelInstrumentBuilder instrumentBuilder;

        Builder(OtelMeter meter, String instrumentName) {
            this.instrumentBuilder = OtelInstrumentBuilder.ofLongs(meter, instrumentName, OtelInstrumentType.COUNTER);
        }

        @Override
        public LongCounterBuilder setDescription(String description) {
            this.instrumentBuilder.setDescription(description);
            return this;
        }

        @Override
        public LongCounterBuilder setUnit(String unit) {
            this.instrumentBuilder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return new OtelDoubleCounter.Builder(this.instrumentBuilder);
        }

        @Override
        public LongCounter build() {
            return new OtelLongCounter();
        }

        @Override
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return OtelMeter.NOOP_METER.counterBuilder("noop").buildWithCallback(callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return OtelMeter.NOOP_METER.counterBuilder("noop").buildObserver();
        }
    }
}

