/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.db;

import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.AttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.AttributesExtractorUtil;

public final class DbClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, DbClientAttributesGetter<REQUEST>> {
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(DbClientAttributesGetter<REQUEST> getter) {
        return new DbClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    DbClientAttributesExtractor(DbClientAttributesGetter<REQUEST> getter) {
        super(getter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, ((DbClientAttributesGetter)this.getter).getStatement(request));
        AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, ((DbClientAttributesGetter)this.getter).getOperation(request));
    }
}

