/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.api.internal;

public final class TemporaryBuffers {
    private static final ThreadLocal<char[]> CHAR_ARRAY = new ThreadLocal();

    public static char[] chars(int len) {
        char[] buffer = CHAR_ARRAY.get();
        if (buffer == null || buffer.length < len) {
            buffer = new char[len];
            CHAR_ARRAY.set(buffer);
        }
        return buffer;
    }

    static void clearChars() {
        CHAR_ARRAY.set(null);
    }

    private TemporaryBuffers() {
    }
}

