/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.directallocation;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.jfr.directallocation.AllocatorHistogram;
import datadog.trace.bootstrap.instrumentation.jfr.directallocation.DirectAllocationSampleEvent;
import datadog.trace.bootstrap.instrumentation.jfr.directallocation.DirectAllocationSampler;
import datadog.trace.bootstrap.instrumentation.jfr.directallocation.DirectAllocationSource;

public class DirectAllocationProfiling {
    private final DirectAllocationSampler sampler;
    private final AllocatorHistogram histogram;
    private final StackWalker stackWalker;

    public static DirectAllocationProfiling getInstance() {
        return Holder.INSTANCE;
    }

    DirectAllocationProfiling(DirectAllocationSampler sampler, AllocatorHistogram histogram) {
        this.sampler = sampler;
        this.histogram = histogram;
        this.stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    }

    private DirectAllocationProfiling(Config config) {
        this(new DirectAllocationSampler(config), new AllocatorHistogram());
    }

    public StackWalker getStackWalker() {
        return this.stackWalker;
    }

    public DirectAllocationSampleEvent sample(DirectAllocationSource source, Class<?> caller, long bytes) {
        boolean firstHit = this.histogram.record(caller, source, bytes);
        if (this.sampler.sample() || firstHit) {
            return new DirectAllocationSampleEvent(caller.getName(), source.name(), bytes);
        }
        return null;
    }

    private static class Holder {
        static final DirectAllocationProfiling INSTANCE = new DirectAllocationProfiling(Config.get());

        private Holder() {
        }
    }
}

