/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api8.java.concurrent;

import datadog.trace.bootstrap.instrumentation.api8.java.concurrent.StatusSettable;
import java.util.concurrent.CompletableFuture;

public class StatusSettingCompletableFuture<T, C>
extends CompletableFuture<T> {
    private final StatusSettable<C> settable;

    public static <T, C> StatusSettingCompletableFuture<T, C> wrap(StatusSettable<C> settable) {
        return new StatusSettingCompletableFuture<T, C>(settable);
    }

    public StatusSettingCompletableFuture(StatusSettable settable) {
        this.settable = settable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean complete(T value) {
        boolean success;
        C context = this.settable.statusStart();
        try {
            success = super.complete(value);
            if (success) {
                this.settable.setSuccess(context);
            }
        }
        finally {
            this.settable.statusFinished(context);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean success;
        C context = this.settable.statusStart();
        try {
            success = super.completeExceptionally(ex);
            if (success) {
                this.settable.setError(context, ex);
            }
        }
        finally {
            this.settable.statusFinished(context);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean success;
        C context = this.settable.statusStart();
        try {
            success = super.cancel(mayInterruptIfRunning);
            if (success) {
                this.settable.setSuccess(context);
            }
        }
        finally {
            this.settable.statusFinished(context);
        }
        return success;
    }
}

