/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.aot;

import datadog.instrument.asm.ClassReader;
import datadog.instrument.asm.ClassVisitor;
import datadog.instrument.asm.ClassWriter;
import datadog.instrument.asm.MethodVisitor;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;

final class TraceApiTransformer
implements ClassFileTransformer {
    private static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    static final String TRACE_INTERCEPTOR = "datadog/trace/api/interceptor/TraceInterceptor";
    static final String PLACEHOLDER_TRACE_INTERCEPTOR = "datadog/trace/bootstrap/aot/PlaceholderTraceInterceptor";

    TraceApiTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] bytecode) {
        if (loader == SYSTEM_CLASS_LOADER) {
            try {
                ClassReader cr = new ClassReader(bytecode);
                ClassWriter cw = new ClassWriter(cr, 0);
                AtomicBoolean modified = new AtomicBoolean();
                cr.accept(new TraceInterceptorPatch(cw, modified), 0);
                if (modified.get()) {
                    return cw.toByteArray();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static final class ReturnPatch
    extends MethodVisitor {
        private final AtomicBoolean modified;

        ReturnPatch(MethodVisitor mv, AtomicBoolean modified) {
            super(589824, mv);
            this.modified = modified;
        }

        @Override
        public void visitInsn(int opcode) {
            if (176 == opcode) {
                this.mv.visitInsn(87);
                this.mv.visitFieldInsn(178, TraceApiTransformer.PLACEHOLDER_TRACE_INTERCEPTOR, "INSTANCE", "Ldatadog/trace/bootstrap/aot/PlaceholderTraceInterceptor;");
                this.mv.visitInsn(176);
                this.modified.set(true);
            } else {
                super.visitInsn(opcode);
            }
        }
    }

    static final class InvokePatch
    extends MethodVisitor {
        private final AtomicBoolean modified;

        InvokePatch(MethodVisitor mv, AtomicBoolean modified) {
            super(589824, mv);
            this.modified = modified;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (185 == opcode && "datadog/trace/api/Tracer".equals(owner) && "addTraceInterceptor".equals(name) && "(Ldatadog/trace/api/interceptor/TraceInterceptor;)Z".equals(descriptor)) {
                this.mv.visitInsn(88);
                this.mv.visitInsn(4);
                this.modified.set(true);
            } else {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }
    }

    static final class TraceInterceptorPatch
    extends ClassVisitor {
        private final AtomicBoolean modified;

        TraceInterceptorPatch(ClassVisitor cv, AtomicBoolean modified) {
            super(589824, cv);
            this.modified = modified;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if ((access & 0x500) == 0) {
                if (descriptor.endsWith(")Ldatadog/trace/api/interceptor/TraceInterceptor;")) {
                    mv = new ReturnPatch(mv, this.modified);
                }
                return new InvokePatch(mv, this.modified);
            }
            return mv;
        }
    }
}

