/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.iast;

import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IastContext
extends Closeable {
    @Nonnull
    public <TO> TO getTaintedObjects();

    public static abstract class Provider {
        private static Provider INSTANCE;

        public static void register(@Nonnull Provider instance) {
            INSTANCE = instance;
        }

        @Nullable
        public abstract IastContext resolve();

        public abstract IastContext buildRequestContext();

        public abstract void releaseRequestContext(@Nonnull IastContext var1);

        @Nullable
        public static IastContext get() {
            if (INSTANCE == null) {
                return Provider.get(AgentTracer.activeSpan());
            }
            return INSTANCE.resolve();
        }

        @Nullable
        public static IastContext get(@Nullable AgentSpan span) {
            if (span == null) {
                return null;
            }
            RequestContext reqCtx = span.getRequestContext();
            if (reqCtx == null) {
                return null;
            }
            return (IastContext)reqCtx.getData(RequestContextSlot.IAST);
        }
    }

    public static enum Mode {
        GLOBAL,
        REQUEST;

    }
}

