/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

public class ProductTraceSource {
    public static final int UNSET = 0;
    public static final int APM = 1;
    public static final int ASM = 2;
    public static final int DSM = 4;
    public static final int DJM = 8;
    public static final int DBM = 16;

    public static int updateProduct(int bitfield, int product) {
        return bitfield |= product;
    }

    public static boolean isProductMarked(int bitfield, int product) {
        return (bitfield & product) != 0;
    }

    public static String getBitfieldHex(int bitfield) {
        String hex = Integer.toHexString(bitfield & 0xFF);
        return hex.length() == 1 ? "0" + hex : hex;
    }

    public static int parseBitfieldHex(String hexString) {
        if (hexString == null || hexString.isEmpty()) {
            return 0;
        }
        return (int)Long.parseUnsignedLong(hexString, 16);
    }
}

