/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentType;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import javax.annotation.Nullable;

final class OtelInstrumentBuilder {
    private final OtelMeter meter;
    private final String instrumentName;
    private final OtelInstrumentType instrumentType;
    private final boolean longValues;
    @Nullable
    private String description;
    @Nullable
    private String unit;

    static OtelInstrumentBuilder ofLongs(OtelMeter meter, String instrumentName, OtelInstrumentType instrumentType) {
        return new OtelInstrumentBuilder(meter, instrumentName, instrumentType, true);
    }

    static OtelInstrumentBuilder ofLongs(OtelInstrumentBuilder builder, OtelInstrumentType instrumentType) {
        return new OtelInstrumentBuilder(builder.meter, builder.instrumentName, instrumentType, true);
    }

    static OtelInstrumentBuilder ofDoubles(OtelMeter meter, String instrumentName, OtelInstrumentType instrumentType) {
        return new OtelInstrumentBuilder(meter, instrumentName, instrumentType, false);
    }

    static OtelInstrumentBuilder ofDoubles(OtelInstrumentBuilder builder, OtelInstrumentType instrumentType) {
        return new OtelInstrumentBuilder(builder.meter, builder.instrumentName, instrumentType, false);
    }

    private OtelInstrumentBuilder(OtelMeter meter, String instrumentName, OtelInstrumentType instrumentType, boolean longValues) {
        this.meter = meter;
        this.instrumentName = instrumentName;
        this.instrumentType = instrumentType;
        this.longValues = longValues;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setUnit(String unit) {
        this.unit = unit;
    }
}

