/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.context.propagation;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.otel.api.trace.TraceState;
import datadog.trace.bootstrap.otel.api.trace.TraceStateBuilder;
import java.util.regex.Pattern;

public final class TraceStateHelper {
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceStateHelper.class);

    private TraceStateHelper() {
    }

    public static TraceState decodeHeader(String header) {
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(header);
        if (listMembers.length > 32) {
            LOGGER.warn("TraceState has too many elements: {}", (Object)header);
            return TraceState.getDefault();
        }
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            if (index == -1) {
                LOGGER.warn("Invalid TraceState list-member format: {}", (Object)listMember);
                return TraceState.getDefault();
            }
            traceStateBuilder.put(listMember.substring(0, index), listMember.substring(index + 1));
        }
        TraceState traceState = traceStateBuilder.build();
        if (traceState.size() != listMembers.length) {
            return TraceState.getDefault();
        }
        return traceState;
    }

    public static String encodeHeader(TraceState traceState) {
        if (traceState.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(512);
        traceState.forEach((key, value) -> {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append((String)key).append('=').append((String)value);
        });
        return builder.toString();
    }
}

