/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.context;

import datadog.context.ContextKey;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import datadog.trace.bootstrap.instrumentation.api.Baggage;
import datadog.trace.bootstrap.instrumentation.api.SpanWrapper;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.Scope;
import datadog.trace.bootstrap.otel.shim.baggage.OtelBaggage;
import datadog.trace.bootstrap.otel.shim.context.OtelScope;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelContext
implements Context {
    public static final Context ROOT = new OtelContext(datadog.context.Context.root());
    private static final String OTEL_CONTEXT_BAGGAGE_KEY = "opentelemetry-baggage-key";
    private static final String OTEL_CONTEXT_SPAN_KEY = "opentelemetry-trace-span-key";
    private static final String OTEL_CONTEXT_ROOT_SPAN_KEY = "opentelemetry-traces-local-root-span";
    private static final Map<datadog.trace.bootstrap.otel.context.ContextKey<?>, ContextKey<?>> DELEGATE_KEYS = new ConcurrentHashMap();
    private final datadog.context.Context delegate;

    public OtelContext(datadog.context.Context delegate) {
        this.delegate = delegate;
    }

    public static Context current() {
        return new OtelContext(datadog.context.Context.current());
    }

    @Override
    public Scope makeCurrent() {
        return new OtelScope(Context.super.makeCurrent(), this.delegate.attach());
    }

    @Override
    @Nullable
    public <V> V get(datadog.trace.bootstrap.otel.context.ContextKey<V> key) {
        Baggage baggage;
        if (OTEL_CONTEXT_SPAN_KEY.equals(key.toString())) {
            AgentSpan span = AgentSpan.fromContext(this.delegate);
            if (span != null && span.isValid()) {
                return (V)OtelContext.toOtelSpan(span);
            }
        } else if (OTEL_CONTEXT_ROOT_SPAN_KEY.equals(key.toString())) {
            AgentSpan span = AgentSpan.fromContext(this.delegate);
            if (span != null && span.isValid()) {
                return (V)OtelContext.toOtelSpan(span.getLocalRootSpan());
            }
        } else if (OTEL_CONTEXT_BAGGAGE_KEY.equals(key.toString()) && (baggage = Baggage.fromContext(this.delegate)) != null) {
            return (V)new OtelBaggage(baggage);
        }
        return (V)this.delegate.get(OtelContext.delegateKey(key));
    }

    @Override
    public <V> Context with(datadog.trace.bootstrap.otel.context.ContextKey<V> key, V value) {
        if (OTEL_CONTEXT_SPAN_KEY.equals(key.toString())) {
            if (value instanceof OtelSpan) {
                AgentSpan span = ((OtelSpan)value).asAgentSpan();
                return new OtelContext(this.delegate.with(span));
            }
        } else if (OTEL_CONTEXT_BAGGAGE_KEY.equals(key.toString())) {
            if (value instanceof OtelBaggage) {
                Baggage baggage = ((OtelBaggage)value).asAgentBaggage();
                return new OtelContext(this.delegate.with(baggage));
            }
            if (value instanceof datadog.trace.bootstrap.otel.api.baggage.Baggage) {
                Baggage baggage = Baggage.empty();
                ((datadog.trace.bootstrap.otel.api.baggage.Baggage)value).forEach((k, b) -> baggage.addItem((String)k, b.getValue()));
                return new OtelContext(this.delegate.with(baggage));
            }
        }
        return new OtelContext(this.delegate.with(OtelContext.delegateKey(key), value));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.delegate.equals(((OtelContext)o).delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return "OtelContext{delegate=" + this.delegate + '}';
    }

    public datadog.context.Context asContext() {
        return this.delegate;
    }

    private static ContextKey delegateKey(datadog.trace.bootstrap.otel.context.ContextKey key) {
        return DELEGATE_KEYS.computeIfAbsent(key, OtelContext::mapByKeyName);
    }

    private static ContextKey mapByKeyName(datadog.trace.bootstrap.otel.context.ContextKey key) {
        return ContextKey.named(key.toString());
    }

    private static OtelSpan toOtelSpan(AgentSpan span) {
        SpanWrapper wrapper;
        if (span instanceof AttachableWrapper && (wrapper = ((AttachableWrapper)((Object)span)).getWrapper()) instanceof OtelSpan) {
            return (OtelSpan)wrapper;
        }
        return new OtelSpan(span);
    }
}

