/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.semconv.http;

import com.google.auto.value.AutoValue;
import datadog.trace.bootstrap.PatchLogger;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogram;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationListener;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationMetrics;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.OperationMetricsUtil;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.AutoValue_HttpServerMetrics_State;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpMetricsAdvice;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class HttpServerMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_METRICS_STATE = ContextKey.named("http-server-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerMetrics.class.getName());
    private final DoubleHistogram duration;

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("http server", HttpServerMetrics::new);
    }

    private HttpServerMetrics(Meter meter) {
        DoubleHistogramBuilder stableDurationBuilder = meter.histogramBuilder("http.server.request.duration").setUnit("s").setDescription("Duration of HTTP server requests.").setExplicitBucketBoundariesAdvice(HttpMetricsAdvice.DURATION_SECONDS_BUCKETS);
        HttpMetricsAdvice.applyServerDurationAdvice(stableDurationBuilder);
        this.duration = stableDurationBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_SERVER_METRICS_STATE, new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(HTTP_SERVER_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

