/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.messaging;

import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.messaging.CapturedMessageHeadersUtil;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractorBuilder;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.AttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.AttributesExtractorUtil;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.SpanKey;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.SpanKeyProvider;
import java.util.List;
import javax.annotation.Nullable;

public final class MessagingAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<Long> MESSAGING_BATCH_MESSAGE_COUNT = AttributeKey.longKey("messaging.batch.message_count");
    private static final AttributeKey<String> MESSAGING_CLIENT_ID = AttributeKey.stringKey("messaging.client_id");
    private static final AttributeKey<Boolean> MESSAGING_DESTINATION_ANONYMOUS = AttributeKey.booleanKey("messaging.destination.anonymous");
    private static final AttributeKey<String> MESSAGING_DESTINATION_NAME = AttributeKey.stringKey("messaging.destination.name");
    private static final AttributeKey<String> MESSAGING_DESTINATION_TEMPLATE = AttributeKey.stringKey("messaging.destination.template");
    private static final AttributeKey<Boolean> MESSAGING_DESTINATION_TEMPORARY = AttributeKey.booleanKey("messaging.destination.temporary");
    private static final AttributeKey<Long> MESSAGING_MESSAGE_BODY_SIZE = AttributeKey.longKey("messaging.message.body.size");
    private static final AttributeKey<String> MESSAGING_MESSAGE_CONVERSATION_ID = AttributeKey.stringKey("messaging.message.conversation_id");
    private static final AttributeKey<Long> MESSAGING_MESSAGE_ENVELOPE_SIZE = AttributeKey.longKey("messaging.message.envelope.size");
    private static final AttributeKey<String> MESSAGING_MESSAGE_ID = AttributeKey.stringKey("messaging.message.id");
    private static final AttributeKey<String> MESSAGING_OPERATION = AttributeKey.stringKey("messaging.operation");
    private static final AttributeKey<String> MESSAGING_SYSTEM = AttributeKey.stringKey("messaging.system");
    static final String TEMP_DESTINATION_NAME = "(temporary)";
    private final MessagingAttributesGetter<REQUEST, RESPONSE> getter;
    private final MessageOperation operation;
    private final List<String> capturedHeaders;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, operation).build();
    }

    public static <REQUEST, RESPONSE> MessagingAttributesExtractorBuilder<REQUEST, RESPONSE> builder(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return new MessagingAttributesExtractorBuilder<REQUEST, RESPONSE>(getter, operation);
    }

    MessagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation, List<String> capturedHeaders) {
        this.getter = getter;
        this.operation = operation;
        this.capturedHeaders = CapturedMessageHeadersUtil.lowercase(capturedHeaders);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_SYSTEM, this.getter.getSystem(request));
        boolean isTemporaryDestination = this.getter.isTemporaryDestination(request);
        if (isTemporaryDestination) {
            AttributesExtractorUtil.internalSet(attributes, MESSAGING_DESTINATION_TEMPORARY, true);
            AttributesExtractorUtil.internalSet(attributes, MESSAGING_DESTINATION_NAME, TEMP_DESTINATION_NAME);
        } else {
            AttributesExtractorUtil.internalSet(attributes, MESSAGING_DESTINATION_NAME, this.getter.getDestination(request));
            AttributesExtractorUtil.internalSet(attributes, MESSAGING_DESTINATION_TEMPLATE, this.getter.getDestinationTemplate(request));
        }
        boolean isAnonymousDestination = this.getter.isAnonymousDestination(request);
        if (isAnonymousDestination) {
            AttributesExtractorUtil.internalSet(attributes, MESSAGING_DESTINATION_ANONYMOUS, true);
        }
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_MESSAGE_CONVERSATION_ID, this.getter.getConversationId(request));
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_MESSAGE_BODY_SIZE, this.getter.getMessageBodySize(request));
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_MESSAGE_ENVELOPE_SIZE, this.getter.getMessageEnvelopeSize(request));
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_CLIENT_ID, this.getter.getClientId(request));
        if (this.operation != null) {
            AttributesExtractorUtil.internalSet(attributes, MESSAGING_OPERATION, this.operation.operationName());
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_MESSAGE_ID, this.getter.getMessageId(request, response));
        AttributesExtractorUtil.internalSet(attributes, MESSAGING_BATCH_MESSAGE_COUNT, this.getter.getBatchMessageCount(request, response));
        for (String name : this.capturedHeaders) {
            List<String> values = this.getter.getMessageHeader(request, name);
            if (values.isEmpty()) continue;
            AttributesExtractorUtil.internalSet(attributes, CapturedMessageHeadersUtil.attributeKey(name), values);
        }
    }

    @Override
    public SpanKey internalGetSpanKey() {
        if (this.operation == null) {
            return null;
        }
        switch (this.operation) {
            case PUBLISH: {
                return SpanKey.PRODUCER;
            }
            case RECEIVE: {
                return SpanKey.CONSUMER_RECEIVE;
            }
            case PROCESS: {
                return SpanKey.CONSUMER_PROCESS;
            }
        }
        throw new IllegalStateException("Can't possibly happen");
    }
}

