/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.http;

import datadog.trace.bootstrap.otel.api.incubator.metrics.ExtendedLongHistogramBuilder;
import datadog.trace.bootstrap.otel.api.incubator.metrics.ExtendedLongUpDownCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongUpDownCounterBuilder;
import datadog.trace.bootstrap.otel.semconv.ErrorAttributes;
import datadog.trace.bootstrap.otel.semconv.HttpAttributes;
import datadog.trace.bootstrap.otel.semconv.NetworkAttributes;
import datadog.trace.bootstrap.otel.semconv.ServerAttributes;
import datadog.trace.bootstrap.otel.semconv.UrlAttributes;
import java.util.Arrays;

final class HttpExperimentalMetricsAdvice {
    static void applyClientRequestSizeAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_REQUEST_METHOD, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, ErrorAttributes.ERROR_TYPE, NetworkAttributes.NETWORK_PROTOCOL_NAME, NetworkAttributes.NETWORK_PROTOCOL_VERSION, ServerAttributes.SERVER_ADDRESS, ServerAttributes.SERVER_PORT));
    }

    static void applyServerRequestSizeAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_ROUTE, HttpAttributes.HTTP_REQUEST_METHOD, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, ErrorAttributes.ERROR_TYPE, NetworkAttributes.NETWORK_PROTOCOL_NAME, NetworkAttributes.NETWORK_PROTOCOL_VERSION, UrlAttributes.URL_SCHEME));
    }

    static void applyServerActiveRequestsAdvice(LongUpDownCounterBuilder builder) {
        if (!(builder instanceof ExtendedLongUpDownCounterBuilder)) {
            return;
        }
        ((ExtendedLongUpDownCounterBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_REQUEST_METHOD, UrlAttributes.URL_SCHEME));
    }

    private HttpExperimentalMetricsAdvice() {
    }
}

