/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.code;

import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.AttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.AttributesExtractorUtil;
import javax.annotation.Nullable;

public final class CodeAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey("code.function");
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey("code.namespace");
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private CodeAttributesExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        Class<?> cls = this.getter.getCodeClass(request);
        if (cls != null) {
            AttributesExtractorUtil.internalSet(attributes, CODE_NAMESPACE, cls.getName());
        }
        AttributesExtractorUtil.internalSet(attributes, CODE_FUNCTION, this.getter.getMethodName(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

