/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.context;

import datadog.trace.bootstrap.PatchLogger;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextStorage;
import datadog.trace.bootstrap.otel.context.Scope;
import datadog.trace.bootstrap.otel.shim.context.OtelContext;
import java.util.logging.Level;
import javax.annotation.Nullable;

enum ThreadLocalContextStorage implements ContextStorage
{
    INSTANCE;

    private static final PatchLogger logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(toAttach);
        return new ScopeImpl(beforeAttach, toAttach);
    }

    @Override
    public Context current() {
        return OtelContext.current();
    }

    static {
        logger = PatchLogger.getLogger(ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }

    private class ScopeImpl
    implements Scope {
        @Nullable
        private final Context beforeAttach;
        private final Context toAttach;
        private boolean closed;

        private ScopeImpl(Context beforeAttach, Context toAttach) {
            this.beforeAttach = beforeAttach;
            this.toAttach = toAttach;
        }

        @Override
        public void close() {
            if (!this.closed && ThreadLocalContextStorage.this.current() == this.toAttach) {
                this.closed = true;
                THREAD_LOCAL_STORAGE.set(this.beforeAttach);
            } else {
                logger.log(Level.FINE, " Trying to close scope which does not represent current context. Ignoring the call.");
            }
        }
    }
}

