/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.api.time.SystemTimeSource;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.NotSampledSpanContext;
import datadog.trace.bootstrap.instrumentation.api.SpanAttributes;
import datadog.trace.bootstrap.instrumentation.api.SpanLink;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.BaseDecorator;
import datadog.trace.bootstrap.instrumentation.websocket.HandlerContext;
import javax.annotation.Nonnull;

public class WebsocketDecorator
extends BaseDecorator {
    private static final CharSequence WEBSOCKET = UTF8BytesString.create("websocket");
    private static final String[] INSTRUMENTATION_NAMES = new String[]{WEBSOCKET.toString()};
    private static final CharSequence WEBSOCKET_RECEIVE = UTF8BytesString.create("websocket.receive");
    private static final CharSequence WEBSOCKET_SEND = UTF8BytesString.create("websocket.send");
    private static final CharSequence WEBSOCKET_CLOSE = UTF8BytesString.create("websocket.close");
    private static final SpanAttributes SPAN_ATTRIBUTES_RECEIVE = SpanAttributes.builder().put("dd.kind", "executed_from").build();
    private static final SpanAttributes SPAN_ATTRIBUTES_SEND = SpanAttributes.builder().put("dd.kind", "resuming").build();
    public static final WebsocketDecorator DECORATE = new WebsocketDecorator();

    @Override
    protected String[] instrumentationNames() {
        return INSTRUMENTATION_NAMES;
    }

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.WEBSOCKET;
    }

    @Override
    protected CharSequence component() {
        return WEBSOCKET;
    }

    @Override
    public AgentSpan afterStart(AgentSpan span) {
        return super.afterStart(span).setMeasured(true);
    }

    @Nonnull
    public AgentSpan onReceiveFrameStart(HandlerContext.Receiver handlerContext, Object data, boolean partialDelivery) {
        handlerContext.recordChunkData(data, partialDelivery);
        return this.onFrameStart(WEBSOCKET_RECEIVE, "consumer", handlerContext, SPAN_ATTRIBUTES_RECEIVE, true);
    }

    @Nonnull
    public AgentSpan onSessionCloseIssued(HandlerContext.Sender handlerContext, CharSequence closeReason, int closeCode) {
        return this.onFrameStart(WEBSOCKET_CLOSE, "producer", handlerContext, SPAN_ATTRIBUTES_SEND, false).setTag("websocket.close.code", closeCode).setTag("websocket.close.reason", closeReason);
    }

    @Nonnull
    public AgentSpan onSessionCloseReceived(HandlerContext.Receiver handlerContext, CharSequence closeReason, int closeCode) {
        return this.onFrameStart(WEBSOCKET_CLOSE, "consumer", handlerContext, SPAN_ATTRIBUTES_RECEIVE, true).setTag("websocket.close.code", closeCode).setTag("websocket.close.reason", closeReason);
    }

    @Nonnull
    public AgentSpan onSendFrameStart(HandlerContext.Sender handlerContext, CharSequence msgType, int msgSize) {
        handlerContext.recordChunkData(msgType, msgSize);
        return this.onFrameStart(WEBSOCKET_SEND, "producer", handlerContext, SPAN_ATTRIBUTES_SEND, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameEnd(HandlerContext handlerContext) {
        if (handlerContext == null) {
            return;
        }
        AgentSpan wsSpan = handlerContext.getWebsocketSpan();
        if (wsSpan == null) {
            return;
        }
        try {
            long chunks;
            long startTime = handlerContext.getFirstFrameTimestamp();
            if (startTime > 0L) {
                wsSpan.setTag("websocket.message.receive_time", SystemTimeSource.INSTANCE.getCurrentTimeNanos() - startTime);
            }
            if ((chunks = handlerContext.getMsgChunks()) > 0L) {
                wsSpan.setTag("websocket.message.frames", chunks);
                wsSpan.setTag("websocket.message.length", handlerContext.getMsgSize());
                wsSpan.setTag("websocket.message.type", handlerContext.getMessageType());
            }
            this.beforeFinish(wsSpan).finish();
        }
        finally {
            handlerContext.reset();
        }
    }

    private AgentSpan onFrameStart(CharSequence operationName, CharSequence spanKind, HandlerContext handlerContext, SpanAttributes linkAttributes, boolean traceStarter) {
        AgentSpan wsSpan = handlerContext.getWebsocketSpan();
        if (wsSpan == null) {
            Config config = Config.get();
            AgentSpan handshakeSpan = handlerContext.getHandshakeSpan();
            boolean inheritSampling = config.isWebsocketMessagesInheritSampling();
            boolean useDedicatedTraces = config.isWebsocketMessagesSeparateTraces();
            if (traceStarter) {
                if (useDedicatedTraces) {
                    wsSpan = AgentTracer.startSpan(WEBSOCKET.toString(), operationName, null);
                    if (inheritSampling) {
                        wsSpan.copyPropagationAndBaggage(handshakeSpan);
                        wsSpan.setTag("_dd.dm.inherited", 1);
                        wsSpan.setTag("_dd.dm.service", handshakeSpan.getServiceName());
                        wsSpan.setTag("_dd.dm.resource", handshakeSpan.getResourceName());
                    }
                } else {
                    wsSpan = AgentTracer.startSpan(WEBSOCKET.toString(), operationName, handshakeSpan.context());
                }
            } else {
                wsSpan = AgentTracer.startSpan(WEBSOCKET.toString(), operationName);
            }
            handlerContext.setWebsocketSpan(wsSpan);
            this.afterStart(wsSpan);
            wsSpan.setTag("span.kind", spanKind);
            wsSpan.setResourceName(handlerContext.getWsResourceName());
            String handshakePeerAddress = (String)handshakeSpan.getTag("peer.hostname");
            if (handshakePeerAddress != null) {
                wsSpan.setTag("peer.hostname", handshakePeerAddress);
            }
            if (config.isWebsocketTagSessionId()) {
                wsSpan.setTag("websocket.session.id", handlerContext.getSessionId());
            }
            if (useDedicatedTraces || !traceStarter) {
                wsSpan.addLink(SpanLink.from(inheritSampling ? handshakeSpan.context() : new NotSampledSpanContext(handshakeSpan.context()), (byte)0, "", linkAttributes));
            }
        }
        return wsSpan;
    }
}

