/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.environment;

import datadog.trace.bootstrap.environment.SystemProperties;
import java.util.ArrayList;
import java.util.List;

final class JavaVersion {
    final int major;
    final int minor;
    final int update;

    JavaVersion(int major, int minor, int update) {
        this.major = major;
        this.minor = minor;
        this.update = update;
    }

    static JavaVersion getRuntimeVersion() {
        return JavaVersion.parseJavaVersion(SystemProperties.getOrDefault("java.version", ""));
    }

    static JavaVersion parseJavaVersion(String javaVersion) {
        int indexOfDash = javaVersion.indexOf(45);
        if (indexOfDash >= 0) {
            javaVersion = javaVersion.substring(0, indexOfDash);
        }
        int major = 0;
        int minor = 0;
        int update = 0;
        try {
            List<Integer> nums = JavaVersion.splitDigits(javaVersion);
            major = nums.get(0);
            if (major == 1) {
                major = nums.get(1);
                minor = nums.get(2);
                update = nums.get(3);
            } else {
                minor = nums.get(1);
                update = nums.get(2);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return new JavaVersion(major, minor, update);
    }

    private static List<Integer> splitDigits(String str) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int len = str.length();
        int value = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                value = value * 10 + (ch - 48);
                continue;
            }
            if (ch == '.' || ch == '_' || ch == '+') {
                results.add(value);
                value = 0;
                continue;
            }
            throw new NumberFormatException();
        }
        results.add(value);
        return results;
    }

    public boolean is(int major) {
        return this.major == major;
    }

    public boolean is(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public boolean is(int major, int minor, int update) {
        return this.major == major && this.minor == minor && this.update == update;
    }

    public boolean isAtLeast(int major) {
        return this.isAtLeast(major, 0, 0);
    }

    public boolean isAtLeast(int major, int minor, int update) {
        return JavaVersion.isAtLeast(this.major, this.minor, this.update, major, minor, update);
    }

    public boolean isBetween(int fromMajor, int fromMinor, int fromUpdate, int toMajor, int toMinor, int toUpdate) {
        return JavaVersion.isAtLeast(toMajor, toMinor, toUpdate, fromMajor, fromMinor, fromUpdate) && this.isAtLeast(fromMajor, fromMinor, fromUpdate) && !this.isAtLeast(toMajor, toMinor, toUpdate);
    }

    private static boolean isAtLeast(int major, int minor, int update, int atLeastMajor, int atLeastMinor, int atLeastUpdate) {
        return major > atLeastMajor || major == atLeastMajor && minor > atLeastMinor || major == atLeastMajor && minor == atLeastMinor && update >= atLeastUpdate;
    }
}

