/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.environment.SystemProperties;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.ConfigCollector;
import datadog.trace.api.ConfigOrigin;
import datadog.trace.bootstrap.config.provider.CapturedEnvironmentConfigSource;
import datadog.trace.bootstrap.config.provider.ConfigConverter;
import datadog.trace.bootstrap.config.provider.EnvironmentConfigSource;
import datadog.trace.bootstrap.config.provider.MapConfigSource;
import datadog.trace.bootstrap.config.provider.OtelEnvironmentConfigSource;
import datadog.trace.bootstrap.config.provider.PropertiesConfigSource;
import datadog.trace.bootstrap.config.provider.StableConfigSource;
import datadog.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import datadog.trace.bootstrap.config.provider.civisibility.CiEnvironmentVariables;
import datadog.trace.util.ConfigStrings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public final class ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigProvider.class);
    private final boolean collectConfig;
    private final Source[] sources;

    private ConfigProvider(Source ... sources) {
        this(true, sources);
    }

    private ConfigProvider(boolean collectConfig, Source ... sources) {
        this.collectConfig = collectConfig;
        this.sources = sources;
    }

    public String getConfigFileStatus() {
        for (Source source : this.sources) {
            String configFileStatus;
            if (!(source instanceof PropertiesConfigSource) || null == (configFileStatus = ((PropertiesConfigSource)source).getConfigFileStatus())) continue;
            return configFileStatus;
        }
        return "no config file present";
    }

    public String getString(String key) {
        return this.getString(key, null, new String[0]);
    }

    public String getString(String key, String defaultValue, String ... aliases) {
        String value;
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        return (value = this.getStringInternal(key, aliases)) != null ? value : defaultValue;
    }

    private String getStringInternal(String key, String ... aliases) {
        ConfigValueResolver<String> resolver = null;
        int seqId = 2;
        for (int i = this.sources.length - 1; i >= 0; --i) {
            Source source = this.sources[i];
            String candidate = source.get(key, aliases);
            if (candidate != null) {
                resolver = ConfigValueResolver.of(candidate);
                if (this.collectConfig) {
                    ConfigCollector.get().put(key, candidate, source.origin(), seqId, ConfigProvider.getConfigIdFromSource(source));
                }
            }
            ++seqId;
        }
        return resolver != null ? (String)resolver.value : null;
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumType, T defaultValue) {
        String value;
        if (this.collectConfig) {
            String defaultValueString = defaultValue == null ? null : defaultValue.name();
            ConfigProvider.reportDefault(key, defaultValueString);
        }
        if (null != (value = this.getStringInternal(key, new String[0]))) {
            try {
                return Enum.valueOf(enumType, value.replace('/', '_').toUpperCase(Locale.ROOT));
            }
            catch (Exception ignoreAndUseDefault) {
                log.debug("failed to parse {} for {}, defaulting to {}", value, key, defaultValue);
            }
        }
        return defaultValue;
    }

    public String getStringNotEmpty(String key, String defaultValue, String ... aliases) {
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        ConfigValueResolver<String> resolver = null;
        int seqId = 2;
        for (int i = this.sources.length - 1; i >= 0; --i) {
            Source source = this.sources[i];
            String candidateValue = source.get(key, aliases);
            if (candidateValue != null) {
                if (this.collectConfig) {
                    ConfigCollector.get().put(key, candidateValue, source.origin(), seqId, ConfigProvider.getConfigIdFromSource(source));
                }
                if (!candidateValue.trim().isEmpty()) {
                    resolver = ConfigValueResolver.of(candidateValue, source.origin(), seqId, ConfigProvider.getConfigIdFromSource(source));
                }
            }
            ++seqId;
        }
        if (resolver != null && this.collectConfig) {
            resolver.reReportToCollector(key, seqId + 1);
        }
        return resolver != null ? (String)resolver.value : defaultValue;
    }

    public String getStringExcludingSource(String key, String defaultValue, Class<? extends Source> excludedSource, String ... aliases) {
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        ConfigValueResolver<String> resolver = null;
        int seqId = 2;
        for (int i = this.sources.length - 1; i >= 0; --i) {
            Source source = this.sources[i];
            String candidate = source.get(key, aliases);
            if (excludedSource.isAssignableFrom(source.getClass())) {
                ++seqId;
                continue;
            }
            if (candidate != null) {
                resolver = ConfigValueResolver.of(candidate);
                if (this.collectConfig) {
                    ConfigCollector.get().put(key, candidate, source.origin(), seqId, ConfigProvider.getConfigIdFromSource(source));
                }
            }
            ++seqId;
        }
        return resolver != null ? (String)resolver.value : defaultValue;
    }

    public boolean isSet(String key) {
        String value = this.getString(key);
        return value != null && !value.isEmpty();
    }

    public Boolean getBoolean(String key) {
        return this.get(key, null, Boolean.class, new String[0]);
    }

    public Boolean getBoolean(String key, String ... aliases) {
        return this.get(key, null, Boolean.class, aliases);
    }

    public boolean getBoolean(String key, boolean defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Boolean.class, aliases);
    }

    public Integer getInteger(String key) {
        return this.get(key, null, Integer.class, new String[0]);
    }

    public Integer getInteger(String key, String ... aliases) {
        return this.get(key, null, Integer.class, aliases);
    }

    public int getInteger(String key, int defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Integer.class, aliases);
    }

    public Long getLong(String key) {
        return this.get(key, null, Long.class, new String[0]);
    }

    public Long getLong(String key, String ... aliases) {
        return this.get(key, null, Long.class, aliases);
    }

    public long getLong(String key, long defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Long.class, aliases);
    }

    public Float getFloat(String key, String ... aliases) {
        return this.get(key, null, Float.class, aliases);
    }

    public float getFloat(String key, float defaultValue) {
        return this.get(key, Float.valueOf(defaultValue), Float.class, new String[0]).floatValue();
    }

    public Double getDouble(String key) {
        return this.get(key, null, Double.class, new String[0]);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key, defaultValue, Double.class, new String[0]);
    }

    public double getDouble(String key, double defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Double.class, aliases);
    }

    private <T> T get(String key, T defaultValue, Class<T> type, String ... aliases) {
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        ConfigValueResolver<Boolean> resolver = null;
        int seqId = 2;
        for (int i = this.sources.length - 1; i >= 0; --i) {
            String sourceValue = this.sources[i].get(key, aliases);
            String configId = ConfigProvider.getConfigIdFromSource(this.sources[i]);
            if (sourceValue != null && this.collectConfig) {
                ConfigCollector.get().put(key, sourceValue, this.sources[i].origin(), seqId, configId);
            }
            try {
                T candidate = ConfigConverter.valueOf(sourceValue, type);
                if (candidate != null) {
                    resolver = ConfigValueResolver.of(candidate, this.sources[i].origin(), seqId, configId);
                }
            }
            catch (ConfigConverter.InvalidBooleanValueException ex) {
                if (Boolean.class.equals(type)) {
                    resolver = ConfigValueResolver.of(Boolean.FALSE, ConfigOrigin.CALCULATED, seqId, configId);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++seqId;
        }
        if (resolver != null && this.collectConfig) {
            resolver.reReportToCollector(key, seqId + 1);
        }
        return resolver != null ? resolver.value : defaultValue;
    }

    public List<String> getList(String key) {
        return ConfigConverter.parseList(this.getString(key));
    }

    public List<String> getList(String key, List<String> defaultValue, String ... aliases) {
        String list;
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        if (null == (list = this.getStringInternal(key, aliases))) {
            return defaultValue;
        }
        return ConfigConverter.parseList(list);
    }

    public Set<String> getSet(String key, Set<String> defaultValue) {
        String list;
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        if (null == (list = this.getStringInternal(key, new String[0]))) {
            return defaultValue;
        }
        return new HashSet<String>(ConfigConverter.parseList(list));
    }

    public List<String> getSpacedList(String key) {
        return ConfigConverter.parseList(this.getString(key), " ");
    }

    public Map<String, String> getMergedMap(String key, String ... aliases) {
        return this.getMergedMap(key, ':', aliases);
    }

    public Map<String, String> getMergedMap(String key, char keyValueDelimiter, String ... aliases) {
        ConfigMergeResolver mergeResolver = new ConfigMergeResolver(new HashMap<String, String>());
        int seqId = 2;
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key, aliases);
            Map<String, String> parsedMap = ConfigConverter.parseMap(value, key, keyValueDelimiter);
            if (parsedMap.isEmpty()) continue;
            if (this.collectConfig) {
                ConfigCollector.get().put(key, parsedMap, this.sources[i].origin(), ++seqId, ConfigProvider.getConfigIdFromSource(this.sources[i]));
            }
            mergeResolver.addContribution(parsedMap, this.sources[i].origin());
        }
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, Collections.emptyMap());
            mergeResolver.reReportFinalResult(key, seqId);
        }
        return mergeResolver.getMergedValue();
    }

    public Map<String, String> getMergedTagsMap(String key, String ... aliases) {
        ConfigMergeResolver mergeResolver = new ConfigMergeResolver(new HashMap<String, String>());
        int seqId = 2;
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key, aliases);
            Map<String, String> parsedMap = ConfigConverter.parseTraceTagsMap(value, ':', Arrays.asList(Character.valueOf(','), Character.valueOf(' ')));
            if (parsedMap.isEmpty()) continue;
            if (this.collectConfig) {
                ConfigCollector.get().put(key, parsedMap, this.sources[i].origin(), ++seqId, ConfigProvider.getConfigIdFromSource(this.sources[i]));
            }
            mergeResolver.addContribution(parsedMap, this.sources[i].origin());
        }
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, Collections.emptyMap());
            mergeResolver.reReportFinalResult(key, seqId);
        }
        return mergeResolver.getMergedValue();
    }

    public Map<String, String> getOrderedMap(String key) {
        ConfigMergeResolver mergeResolver = new ConfigMergeResolver(new LinkedHashMap<String, String>());
        int seqId = 2;
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key);
            Map<String, String> parsedMap = ConfigConverter.parseOrderedMap(value, key);
            if (parsedMap.isEmpty()) continue;
            if (this.collectConfig) {
                ConfigCollector.get().put(key, parsedMap, this.sources[i].origin(), ++seqId, ConfigProvider.getConfigIdFromSource(this.sources[i]));
            }
            mergeResolver.addContribution(parsedMap, this.sources[i].origin());
        }
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, Collections.emptyMap());
            mergeResolver.reReportFinalResult(key, seqId);
        }
        return mergeResolver.getMergedValue();
    }

    public Map<String, String> getMergedMapWithOptionalMappings(String defaultPrefix, boolean lowercaseKeys, String ... keys) {
        ConfigMergeResolver mergeResolver = new ConfigMergeResolver(new HashMap<String, String>());
        int seqId = 2;
        for (String key : keys) {
            for (int i = this.sources.length - 1; 0 <= i; --i) {
                String value = this.sources[i].get(key);
                Map<String, String> parsedMap = ConfigConverter.parseMapWithOptionalMappings(value, key, defaultPrefix, lowercaseKeys);
                if (parsedMap.isEmpty()) continue;
                if (this.collectConfig) {
                    ConfigCollector.get().put(key, parsedMap, this.sources[i].origin(), ++seqId, ConfigProvider.getConfigIdFromSource(this.sources[i]));
                }
                mergeResolver.addContribution(parsedMap, this.sources[i].origin());
            }
            if (!this.collectConfig) continue;
            ConfigProvider.reportDefault(key, Collections.emptyMap());
            mergeResolver.reReportFinalResult(key, seqId);
        }
        return mergeResolver.getMergedValue();
    }

    public BitSet getIntegerRange(String key, BitSet defaultValue, String ... aliases) {
        if (this.collectConfig) {
            ConfigProvider.reportDefault(key, defaultValue);
        }
        String value = this.getStringInternal(key, aliases);
        try {
            if (value != null) {
                return ConfigConverter.parseIntegerRangeSet(value, key);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for {}", (Object)key, (Object)e);
        }
        return defaultValue;
    }

    public boolean isEnabled(Iterable<String> settingNames, String settingPrefix, String settingSuffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : settingNames) {
            String configKey = settingPrefix + name + settingSuffix;
            String fullKey = configKey.startsWith("trace.") ? configKey : "trace." + configKey;
            boolean configEnabled = this.getBoolean(fullKey, defaultEnabled, configKey);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public static ConfigProvider getInstance() {
        return Singleton.INSTANCE;
    }

    public static ConfigProvider createDefault() {
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource()));
        PropertiesConfigSource propertiesSource = !configProperties.isEmpty() ? new PropertiesConfigSource(configProperties, true) : null;
        Map<String, String> ciEnvironmentVariables = CiEnvironmentVariables.getAll();
        MapConfigSource ciEnvironmentSource = ciEnvironmentVariables != null ? new MapConfigSource(ciEnvironmentVariables, ConfigStrings::propertyNameToEnvironmentVariableName, ConfigOrigin.ENV) : null;
        return new ConfigProvider(ConfigProvider.filterNonNull(new SystemPropertiesConfigSource(), StableConfigSource.FLEET, ciEnvironmentSource, new EnvironmentConfigSource(), propertiesSource, new OtelEnvironmentConfigSource(), StableConfigSource.LOCAL, new CapturedEnvironmentConfigSource()));
    }

    private static Source[] filterNonNull(Source ... values) {
        return (Source[])Arrays.stream(values).filter(Objects::nonNull).toArray(Source[]::new);
    }

    public static ConfigProvider withoutCollector() {
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(false, new SystemPropertiesConfigSource(), new EnvironmentConfigSource()));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(false, new SystemPropertiesConfigSource(), StableConfigSource.FLEET, new EnvironmentConfigSource(), new OtelEnvironmentConfigSource(), StableConfigSource.LOCAL, new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(false, new SystemPropertiesConfigSource(), StableConfigSource.FLEET, new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new OtelEnvironmentConfigSource(configProperties), StableConfigSource.LOCAL, new CapturedEnvironmentConfigSource());
    }

    public static ConfigProvider withPropertiesOverride(Properties properties) {
        PropertiesConfigSource providedConfigSource = new PropertiesConfigSource(properties, false);
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), providedConfigSource));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(new SystemPropertiesConfigSource(), StableConfigSource.FLEET, new EnvironmentConfigSource(), providedConfigSource, new OtelEnvironmentConfigSource(), StableConfigSource.LOCAL, new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(providedConfigSource, new SystemPropertiesConfigSource(), StableConfigSource.FLEET, new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new OtelEnvironmentConfigSource(configProperties), StableConfigSource.LOCAL, new CapturedEnvironmentConfigSource());
    }

    @SuppressForbidden
    private static Properties loadConfigurationFile(ConfigProvider configProvider) {
        File configurationFile;
        String home;
        Properties properties = new Properties();
        String configurationFilePath = configProvider.getString("trace.config");
        if (null == configurationFilePath) {
            return properties;
        }
        if (configurationFilePath.charAt(0) == '~' && (home = SystemProperties.get("user.home")) != null) {
            configurationFilePath = home + configurationFilePath.substring(1);
        }
        if (!(configurationFile = new File(configurationFilePath)).exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try (FileReader fileReader = new FileReader(configurationFile);){
            properties.load(fileReader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        properties.setProperty("_dd.config.file.status", configurationFilePath);
        return properties;
    }

    private static String getConfigIdFromSource(Source source) {
        if (source instanceof StableConfigSource) {
            return ((StableConfigSource)source).getConfigId();
        }
        return null;
    }

    private static <T> void reportDefault(String key, T defaultValue) {
        ConfigCollector.get().putDefault(key, defaultValue);
    }

    public static abstract class Source {
        public final String get(String key, String ... aliases) {
            String value = this.get(key);
            if (value != null) {
                return value;
            }
            for (String alias : aliases) {
                value = this.get(alias);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        protected abstract String get(String var1);

        public abstract ConfigOrigin origin();
    }

    static final class ConfigValueResolver<T> {
        final T value;
        final ConfigOrigin origin;
        final int seqId;
        final String configId;

        private ConfigValueResolver(T value, ConfigOrigin origin, int seqId, String configId) {
            this.value = value;
            this.origin = origin;
            this.seqId = seqId;
            this.configId = configId;
        }

        static <T> ConfigValueResolver<T> of(T value) {
            return new ConfigValueResolver<T>(value, null, 0, null);
        }

        static <T> ConfigValueResolver<T> of(T value, ConfigOrigin origin, int seqId, String configId) {
            return new ConfigValueResolver<T>(value, origin, seqId, configId);
        }

        void reReportToCollector(String key, int finalSeqId) {
            if (this.origin != null) {
                ConfigCollector.get().put(key, this.value, this.origin, finalSeqId, this.configId);
            }
        }
    }

    private static final class ConfigMergeResolver {
        private final Map<String, String> mergedValue;
        private ConfigOrigin currentOrigin;

        ConfigMergeResolver(Map<String, String> initialValue) {
            this.mergedValue = initialValue;
            this.currentOrigin = ConfigOrigin.DEFAULT;
        }

        void addContribution(Map<String, String> contribution, ConfigOrigin sourceOrigin) {
            this.mergedValue.putAll(contribution);
            this.currentOrigin = this.currentOrigin != ConfigOrigin.DEFAULT ? ConfigOrigin.CALCULATED : sourceOrigin;
        }

        void reReportFinalResult(String key, int finalSeqId) {
            if (this.currentOrigin != ConfigOrigin.DEFAULT && !this.mergedValue.isEmpty()) {
                ConfigCollector.get().put(key, this.mergedValue, this.currentOrigin, finalSeqId);
            }
        }

        Map<String, String> getMergedValue() {
            return this.mergedValue;
        }
    }

    private static final class Singleton {
        private static final ConfigProvider INSTANCE = ConfigProvider.createDefault();

        private Singleton() {
        }
    }
}

