/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public abstract class InitializationTelemetry {
    public static final InitializationTelemetry proxy(Object bootstrapInitTelemetry) {
        if (bootstrapInitTelemetry == null) {
            return InitializationTelemetry.noOpInstance();
        }
        return new BootstrapProxy(bootstrapInitTelemetry);
    }

    public static final InitializationTelemetry noOpInstance() {
        return NoOp.INSTANCE;
    }

    public abstract void onAbort(String var1);

    public abstract void onError(Throwable var1);

    public abstract void onFatalError(Throwable var1);

    public abstract void onError(String var1);

    public abstract void markIncomplete();

    static final class BootstrapProxy
    extends InitializationTelemetry {
        private final Object bootstrapInitTelemetry;
        private volatile MethodHandle bmh_onAbortString;
        private volatile MethodHandle bmh_onErrorString;
        private volatile MethodHandle bmh_onErrorThrowable;
        private volatile MethodHandle bmh_onFatalErrorThrowable;
        private volatile MethodHandle bmh_markIncomplete;

        BootstrapProxy(Object bootstrapInitTelemetry) {
            this.bootstrapInitTelemetry = bootstrapInitTelemetry;
        }

        @Override
        public void onAbort(String reasonCode) {
            MethodHandle bmh_onAbortString = this.bmh_onAbortString;
            if (bmh_onAbortString == null) {
                this.bmh_onAbortString = bmh_onAbortString = this.findBoundHandle("onAbort", String.class);
            }
            if (bmh_onAbortString != null) {
                try {
                    bmh_onAbortString.invokeExact(reasonCode);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onError(String reasonCode) {
            MethodHandle bmh_onErrorString = this.bmh_onErrorString;
            if (bmh_onErrorString == null) {
                this.bmh_onErrorString = bmh_onErrorString = this.findBoundHandle("onError", String.class);
            }
            if (bmh_onErrorString != null) {
                try {
                    bmh_onErrorString.invokeExact(reasonCode);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onError(Throwable cause) {
            MethodHandle bmh_onErrorThrowable = this.bmh_onErrorThrowable;
            if (bmh_onErrorThrowable == null) {
                this.bmh_onErrorThrowable = bmh_onErrorThrowable = this.findBoundHandle("onError", Throwable.class);
            }
            if (bmh_onErrorThrowable != null) {
                try {
                    bmh_onErrorThrowable.invokeExact(cause);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void onFatalError(Throwable cause) {
            MethodHandle bmh_onFatalErrorThrowable = this.bmh_onFatalErrorThrowable;
            if (bmh_onFatalErrorThrowable == null) {
                this.bmh_onFatalErrorThrowable = bmh_onFatalErrorThrowable = this.findBoundHandle("onFatalError", Throwable.class);
            }
            if (bmh_onFatalErrorThrowable != null) {
                try {
                    bmh_onFatalErrorThrowable.invokeExact(cause);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void markIncomplete() {
            MethodHandle bmh_markIncomplete = this.bmh_markIncomplete;
            if (bmh_markIncomplete == null) {
                this.bmh_markIncomplete = bmh_markIncomplete = this.findBoundHandle("markIncomplete");
            }
            if (bmh_markIncomplete != null) {
                try {
                    bmh_markIncomplete.invokeExact();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private final MethodHandle findBoundHandle(String name, Class<?> paramType) {
            try {
                MethodHandle virtualHandle = MethodHandles.publicLookup().findVirtual(this.bootstrapInitTelemetry.getClass(), name, MethodType.methodType(Void.TYPE, paramType));
                return virtualHandle.bindTo(this.bootstrapInitTelemetry);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                return null;
            }
        }

        private final MethodHandle findBoundHandle(String name) {
            try {
                MethodHandle virtualHandle = MethodHandles.publicLookup().findVirtual(this.bootstrapInitTelemetry.getClass(), name, MethodType.methodType(Void.TYPE));
                return virtualHandle.bindTo(this.bootstrapInitTelemetry);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                return null;
            }
        }
    }

    static final class NoOp
    extends InitializationTelemetry {
        static final NoOp INSTANCE = new NoOp();

        NoOp() {
        }

        @Override
        public void onAbort(String reasonCode) {
        }

        @Override
        public void onError(String reasonCode) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onFatalError(Throwable t) {
        }

        @Override
        public void markIncomplete() {
        }
    }
}

