/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.rum;

import datadog.trace.api.Config;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.rum.RumInjector;
import datadog.trace.api.rum.RumInjectorConfig;
import datadog.trace.api.rum.RumTelemetryCollector;
import datadog.trace.api.telemetry.MetricCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class RumInjectorMetrics
implements RumTelemetryCollector {
    private final Queue<MetricCollector.Metric> metrics = new LinkedBlockingQueue<MetricCollector.Metric>(1024);
    private final Queue<MetricCollector.DistributionSeriesPoint> distributions = new LinkedBlockingQueue<MetricCollector.DistributionSeriesPoint>(1024);
    private final DDCache<String, List<String>> succeedTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, List<String>> skippedTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, List<String>> cspTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, List<String>> responseTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, List<String>> timeTagsCache = DDCaches.newFixedSizeCache(8);
    private final DDCache<String, List<String>> failedTagsCache = DDCaches.newFixedSizeCache(16);
    private final DDCache<String, List<String>> initTagsCache = DDCaches.newFixedSizeCache(1);
    private final String applicationId;
    private final String remoteConfigUsed;

    public RumInjectorMetrics() {
        RumInjector rumInjector = RumInjector.get();
        RumInjectorConfig injectorConfig = Config.get().getRumInjectorConfig();
        if (rumInjector.isEnabled() && injectorConfig != null) {
            this.applicationId = injectorConfig.applicationId;
            this.remoteConfigUsed = injectorConfig.remoteConfigurationId != null ? "true" : "false";
        } else {
            this.applicationId = "unknown";
            this.remoteConfigUsed = "false";
        }
    }

    @Override
    public void onInjectionSucceed(String servletVersion) {
        List tags = this.succeedTagsCache.computeIfAbsent(servletVersion, version -> Arrays.asList("application_id:" + this.applicationId, "integration_name:servlet", "integration_version:" + version, "remote_config_used:" + this.remoteConfigUsed));
        MetricCollector.Metric metric = new MetricCollector.Metric("rum", true, "injection.succeed", "count", (Number)1, tags);
        this.metrics.offer(metric);
    }

    @Override
    public void onInjectionFailed(String servletVersion, String contentEncoding) {
        String cacheKey = servletVersion + ":" + contentEncoding;
        List tags = this.failedTagsCache.computeIfAbsent(cacheKey, key -> {
            if (contentEncoding != null) {
                return Arrays.asList("application_id:" + this.applicationId, "content_encoding:" + contentEncoding, "integration_name:servlet", "integration_version:" + servletVersion, "reason:failed_to_return_response_wrapper", "remote_config_used:" + this.remoteConfigUsed);
            }
            return Arrays.asList("application_id:" + this.applicationId, "integration_name:servlet", "integration_version:" + servletVersion, "reason:failed_to_return_response_wrapper", "remote_config_used:" + this.remoteConfigUsed);
        });
        MetricCollector.Metric metric = new MetricCollector.Metric("rum", true, "injection.failed", "count", (Number)1, tags);
        this.metrics.offer(metric);
    }

    @Override
    public void onInjectionSkipped(String servletVersion) {
        List tags = this.skippedTagsCache.computeIfAbsent(servletVersion, version -> Arrays.asList("application_id:" + this.applicationId, "integration_name:servlet", "integration_version:" + version, "reason:should_not_inject", "remote_config_used:" + this.remoteConfigUsed));
        MetricCollector.Metric metric = new MetricCollector.Metric("rum", true, "injection.skipped", "count", (Number)1, tags);
        this.metrics.offer(metric);
    }

    @Override
    public void onInitializationSucceed() {
        List tags = this.initTagsCache.computeIfAbsent("init", key -> Arrays.asList("integration_name:servlet", "integration_version:N/A"));
        MetricCollector.Metric metric = new MetricCollector.Metric("rum", true, "injection.initialization.succeed", "count", (Number)1, tags);
        this.metrics.offer(metric);
    }

    @Override
    public void onContentSecurityPolicyDetected(String servletVersion) {
        List tags = this.cspTagsCache.computeIfAbsent(servletVersion, version -> Arrays.asList("integration_name:servlet", "integration_version:" + version, "kind:header", "reason:csp_header_found", "status:seen"));
        MetricCollector.Metric metric = new MetricCollector.Metric("rum", true, "injection.content_security_policy", "count", (Number)1, tags);
        this.metrics.offer(metric);
    }

    @Override
    public void onInjectionResponseSize(String servletVersion, long bytes) {
        List tags = this.responseTagsCache.computeIfAbsent(servletVersion, version -> Arrays.asList("integration_name:servlet", "integration_version:" + version, "response_kind:header"));
        MetricCollector.DistributionSeriesPoint distribution = new MetricCollector.DistributionSeriesPoint("injection.response.bytes", true, "rum", (int)bytes, tags);
        this.distributions.offer(distribution);
    }

    @Override
    public void onInjectionTime(String servletVersion, long milliseconds) {
        List tags = this.timeTagsCache.computeIfAbsent(servletVersion, version -> Arrays.asList("integration_name:servlet", "integration_version:" + version));
        MetricCollector.DistributionSeriesPoint distribution = new MetricCollector.DistributionSeriesPoint("injection.ms", true, "rum", (int)milliseconds, tags);
        this.distributions.offer(distribution);
    }

    @Override
    public void close() {
        this.metrics.clear();
        this.distributions.clear();
        this.succeedTagsCache.clear();
        this.skippedTagsCache.clear();
        this.cspTagsCache.clear();
        this.responseTagsCache.clear();
        this.timeTagsCache.clear();
        this.failedTagsCache.clear();
        this.initTagsCache.clear();
    }

    @Override
    public synchronized Collection<MetricCollector.Metric> drain() {
        if (this.metrics.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetricCollector.Metric> drained = new ArrayList<MetricCollector.Metric>(this.metrics);
        this.metrics.clear();
        return drained;
    }

    @Override
    public synchronized Collection<MetricCollector.DistributionSeriesPoint> drainDistributionSeries() {
        if (this.distributions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetricCollector.DistributionSeriesPoint> drained = new ArrayList<MetricCollector.DistributionSeriesPoint>(this.distributions);
        this.distributions.clear();
        return drained;
    }
}

