/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.gateway;

import datadog.trace.api.appsec.HttpClientRequest;
import datadog.trace.api.appsec.HttpClientResponse;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.function.TriFunction;
import datadog.trace.api.gateway.EventType;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.IGSpanInfo;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.http.StoredBodySupplier;
import datadog.trace.api.telemetry.LoginEvent;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Events<D> {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    static final int REQUEST_STARTED_ID = 0;
    private static final EventType REQUEST_STARTED = new ET("request.started", 0);
    static final int REQUEST_ENDED_ID = 1;
    private static final EventType REQUEST_ENDED = new ET("request.ended", 1);
    static final int REQUEST_HEADER_ID = 2;
    private static final EventType REQUEST_HEADER = new ET("server.request.header", 2);
    static final int REQUEST_HEADER_DONE_ID = 3;
    private static final EventType REQUEST_HEADER_DONE = new ET("server.request.header.done", 3);
    static final int REQUEST_METHOD_URI_RAW_ID = 4;
    private static final EventType REQUEST_METHOD_URI_RAW = new ET("server.request.method.uri.raw", 4);
    static final int REQUEST_PATH_PARAMS_ID = 5;
    private static final EventType REQUEST_PATH_PARAMS = new ET("server.request.method.uri.raw", 5);
    static final int REQUEST_CLIENT_SOCKET_ADDRESS_ID = 6;
    private static final EventType REQUEST_CLIENT_SOCKET_ADDRESS = new ET("http.server.client_socket_address", 6);
    static final int REQUEST_INFERRED_CLIENT_ADDRESS_ID = 7;
    private static final EventType REQUEST_INFERRED_CLIENT_ADDRESS = new ET("http.server.inferred_client_address", 7);
    static final int REQUEST_BODY_START_ID = 8;
    private static final EventType REQUEST_BODY_START = new ET("request.body.started", 8);
    static final int REQUEST_BODY_DONE_ID = 9;
    private static final EventType REQUEST_BODY_DONE = new ET("request.body.done", 9);
    static final int REQUEST_BODY_CONVERTED_ID = 10;
    private static final EventType REQUEST_BODY_CONVERTED = new ET("request.body.converted", 10);
    static final int RESPONSE_STARTED_ID = 11;
    private static final EventType RESPONSE_STARTED = new ET("response.started", 11);
    static final int RESPONSE_HEADER_ID = 12;
    private static final EventType RESPONSE_HEADER = new ET("server.response.header", 12);
    static final int RESPONSE_HEADER_DONE_ID = 13;
    private static final EventType RESPONSE_HEADER_DONE = new ET("server.response.header.done", 13);
    static final int GRPC_SERVER_REQUEST_MESSAGE_ID = 14;
    private static final EventType GRPC_SERVER_REQUEST_MESSAGE = new ET("grpc.server.request.message", 14);
    static final int GRAPHQL_SERVER_REQUEST_MESSAGE_ID = 15;
    private static final EventType GRAPHQL_SERVER_REQUEST_MESSAGE = new ET("graphql.server.request.message", 15);
    static final int DATABASE_CONNECTION_ID = 16;
    private static final EventType DATABASE_CONNECTION = new ET("database.connection", 16);
    static final int DATABASE_SQL_QUERY_ID = 17;
    private static final EventType DATABASE_SQL_QUERY = new ET("database.query", 17);
    static final int GRPC_SERVER_METHOD_ID = 18;
    private static final EventType GRPC_SERVER_METHOD = new ET("grpc.server.method", 18);
    static final int HTTP_CLIENT_REQUEST_ID = 19;
    private static final EventType HTTP_CLIENT_REQUEST = new ET("http.client.request", 19);
    static final int FILE_LOADED_ID = 20;
    private static final EventType FILE_LOADED = new ET("file.loaded", 20);
    static final int REQUEST_SESSION_ID = 21;
    private static final EventType REQUEST_SESSION = new ET("request.session", 21);
    static final int USER_ID = 22;
    private static final EventType USER = new ET("user", 22);
    static final int LOGIN_EVENT_ID = 23;
    private static final EventType LOGIN_EVENT = new ET("login.event", 23);
    static final int EXEC_CMD_ID = 24;
    private static final EventType EXEC_CMD = new ET("exec.cmd", 24);
    static final int SHELL_CMD_ID = 25;
    private static final EventType SHELL_CMD = new ET("shell.cmd", 25);
    static final int HTTP_ROUTE_ID = 26;
    private static final EventType HTTP_ROUTE = new ET("http.route", 26);
    static final int RESPONSE_BODY_ID = 27;
    private static final EventType RESPONSE_BODY = new ET("response.body", 27);
    static final int HTTP_CLIENT_RESPONSE_ID = 28;
    private static final EventType HTTP_CLIENT_RESPONSE = new ET("http.client.response", 28);
    static final int HTTP_CLIENT_SAMPLING_ID = 29;
    private static final EventType HTTP_CLIENT_SAMPLING = new ET("http.client.sampling", 29);
    static final int MAX_EVENTS = nextId.get();
    public static final Events<Object> EVENTS = new Events();

    public EventType<Supplier<Flow<D>>> requestStarted() {
        return REQUEST_STARTED;
    }

    public EventType<BiFunction<RequestContext, IGSpanInfo, Flow<Void>>> requestEnded() {
        return REQUEST_ENDED;
    }

    public EventType<TriConsumer<RequestContext, String, String>> requestHeader() {
        return REQUEST_HEADER;
    }

    public EventType<Function<RequestContext, Flow<Void>>> requestHeaderDone() {
        return REQUEST_HEADER_DONE;
    }

    public EventType<TriFunction<RequestContext, String, URIDataAdapter, Flow<Void>>> requestMethodUriRaw() {
        return REQUEST_METHOD_URI_RAW;
    }

    public EventType<BiFunction<RequestContext, Map<String, ?>, Flow<Void>>> requestPathParams() {
        return REQUEST_PATH_PARAMS;
    }

    public EventType<TriFunction<RequestContext, String, Integer, Flow<Void>>> requestClientSocketAddress() {
        return REQUEST_CLIENT_SOCKET_ADDRESS;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> requestInferredClientAddress() {
        return REQUEST_INFERRED_CLIENT_ADDRESS;
    }

    public EventType<BiFunction<RequestContext, StoredBodySupplier, Void>> requestBodyStart() {
        return REQUEST_BODY_START;
    }

    public EventType<BiFunction<RequestContext, StoredBodySupplier, Flow<Void>>> requestBodyDone() {
        return REQUEST_BODY_DONE;
    }

    public EventType<BiFunction<RequestContext, Object, Flow<Void>>> requestBodyProcessed() {
        return REQUEST_BODY_CONVERTED;
    }

    public EventType<BiFunction<RequestContext, Integer, Flow<Void>>> responseStarted() {
        return RESPONSE_STARTED;
    }

    public EventType<TriConsumer<RequestContext, String, String>> responseHeader() {
        return RESPONSE_HEADER;
    }

    public EventType<Function<RequestContext, Flow<Void>>> responseHeaderDone() {
        return RESPONSE_HEADER_DONE;
    }

    public EventType<BiFunction<RequestContext, Object, Flow<Void>>> grpcServerRequestMessage() {
        return GRPC_SERVER_REQUEST_MESSAGE;
    }

    public EventType<BiFunction<RequestContext, Map<String, ?>, Flow<Void>>> graphqlServerRequestMessage() {
        return GRAPHQL_SERVER_REQUEST_MESSAGE;
    }

    public EventType<BiConsumer<RequestContext, String>> databaseConnection() {
        return DATABASE_CONNECTION;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> databaseSqlQuery() {
        return DATABASE_SQL_QUERY;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> grpcServerMethod() {
        return GRPC_SERVER_METHOD;
    }

    public EventType<BiFunction<RequestContext, HttpClientRequest, Flow<Void>>> httpClientRequest() {
        return HTTP_CLIENT_REQUEST;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> fileLoaded() {
        return FILE_LOADED;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> requestSession() {
        return REQUEST_SESSION;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> user() {
        return USER;
    }

    public EventType<TriFunction<RequestContext, LoginEvent, String, Flow<Void>>> loginEvent() {
        return LOGIN_EVENT;
    }

    public EventType<BiFunction<RequestContext, String[], Flow<Void>>> execCmd() {
        return EXEC_CMD;
    }

    public EventType<BiFunction<RequestContext, String, Flow<Void>>> shellCmd() {
        return SHELL_CMD;
    }

    public EventType<BiConsumer<RequestContext, String>> httpRoute() {
        return HTTP_ROUTE;
    }

    public EventType<BiFunction<RequestContext, Object, Flow<Void>>> responseBody() {
        return RESPONSE_BODY;
    }

    public EventType<BiFunction<RequestContext, HttpClientResponse, Flow<Void>>> httpClientResponse() {
        return HTTP_CLIENT_RESPONSE;
    }

    public EventType<BiFunction<RequestContext, Long, Flow<Boolean>>> httpClientSampling() {
        return HTTP_CLIENT_SAMPLING;
    }

    private Events() {
    }

    public static <D> Events<D> get() {
        return EVENTS;
    }

    private static final class ET<T>
    extends EventType<T> {
        public ET(String type, int id) {
            super(type, id);
            int expectedId = nextId.getAndIncrement();
            if (id != expectedId) {
                throw new IllegalArgumentException("Event " + type + " has broken id " + id + ", expected " + expectedId + ".");
            }
        }
    }
}

