/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.appsec;

import java.util.Locale;

public class MediaType {
    public static final MediaType UNKNOWN = new MediaType(null, null, null);
    private final String type;
    private final String subtype;
    private final String charset;

    private MediaType(String type, String subtype, String charset) {
        this.type = type;
        this.subtype = subtype;
        this.charset = charset;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isJson() {
        return this.subtype != null && ("json".equals(this.subtype) || this.subtype.endsWith("+json"));
    }

    public boolean isDeserializable() {
        return this.isJson();
    }

    public String toString() {
        String contentType = this.type + "/" + this.subtype;
        if (this.charset != null) {
            contentType = contentType + "; charset=" + this.charset;
        }
        return contentType;
    }

    public static MediaType parse(String header) {
        String contentType;
        if (header == null) {
            return UNKNOWN;
        }
        String mediaType = header.trim().toLowerCase(Locale.ROOT);
        int semicolonIndex = mediaType.indexOf(59);
        String charset = null;
        if (semicolonIndex != -1) {
            contentType = mediaType.substring(0, semicolonIndex);
            String parameter = mediaType.substring(semicolonIndex + 1);
            int charsetIndex = parameter.indexOf("charset=");
            if (charsetIndex != -1) {
                charset = parameter.substring(charsetIndex + 8);
            }
        } else {
            contentType = mediaType;
        }
        int slashIndex = contentType.indexOf(47);
        if (slashIndex != -1) {
            String type = contentType.substring(0, slashIndex);
            String subtype = contentType.substring(slashIndex + 1);
            return MediaType.create(type, subtype, charset);
        }
        return MediaType.create(contentType, null, charset);
    }

    public static MediaType create(String type, String subtype, String charset) {
        return new MediaType(MediaType.trimValue(type), MediaType.trimValue(subtype), MediaType.trimValue(charset));
    }

    public static String trimValue(String value) {
        if (value == null) {
            return null;
        }
        return (value = value.trim()).isEmpty() ? null : value;
    }
}

