/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.GlobalTracer;
import datadog.trace.api.Tracer;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;

public class WithGlobalTracer {
    private static final Logger log = LoggerFactory.getLogger(WithGlobalTracer.class);

    private WithGlobalTracer() {
    }

    public static void registerOrExecute(final Callback callback) {
        GlobalTracer.registerInstallationCallback(new GlobalTracer.Callback(){

            @Override
            public void installed(Tracer tracer) {
                if (tracer instanceof AgentTracer.TracerAPI) {
                    callback.withTracer((AgentTracer.TracerAPI)tracer);
                } else {
                    log.warn("Unsupported tracer type {}", (Object)tracer.getClass().getName());
                }
            }
        });
    }

    public static interface Callback {
        public void withTracer(AgentTracer.TracerAPI var1);
    }
}

