/*
 * Decompiled with CFR 0.152.
 */
package datadog.json;

import datadog.json.JsonStructure;
import datadog.json.LenientJsonStructure;
import datadog.json.SafeJsonStructure;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;

public class JsonReader
implements AutoCloseable {
    private static final int BUFFER_SIZE = 1024;
    private final Reader reader;
    private final char[] buffer = new char[1024];
    private final JsonStructure structure;
    private int position = 0;
    private int limit = 0;
    private int lineNumber = 1;
    private int linePosition = 0;

    public JsonReader(String json) {
        this(new StringReader(json), true);
    }

    public JsonReader(Reader reader) {
        this(reader, true);
    }

    public JsonReader(Reader reader, boolean safe) {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        this.reader = reader;
        this.structure = safe ? new SafeJsonStructure() : new LenientJsonStructure();
    }

    public JsonReader beginObject() throws IOException {
        char c = this.advanceUpToNextValueChar();
        if (c != '{') {
            throw this.unexpectedSyntaxError("'{'", c);
        }
        this.advance();
        this.structure.beginObject();
        return this;
    }

    public JsonReader endObject() throws IOException {
        this.consumeWhitespace();
        char c = this.peek();
        if (c != '}') {
            throw this.unexpectedSyntaxError("'}'", c);
        }
        this.advance();
        this.structure.endObject();
        return this;
    }

    public JsonReader beginArray() throws IOException {
        char c = this.advanceUpToNextValueChar();
        if (c != '[') {
            throw this.unexpectedSyntaxError("'['", c);
        }
        this.advance();
        this.structure.beginArray();
        return this;
    }

    public JsonReader endArray() throws IOException {
        this.consumeWhitespace();
        char c = this.peek();
        if (c != ']') {
            throw this.unexpectedSyntaxError("']'", c);
        }
        this.advance();
        this.structure.endArray();
        return this;
    }

    public String nextName() throws IOException {
        char c = this.advanceUpToNextValueChar();
        if (c == '}') {
            return null;
        }
        if (c != '\"') {
            throw this.unexpectedSyntaxError("'\"'", c);
        }
        String name = this.readString();
        this.consumeWhitespace();
        c = this.peek();
        if (c != ':') {
            throw this.unexpectedSyntaxError("':'", c);
        }
        this.advance();
        this.structure.addName();
        return name;
    }

    public boolean isNull() throws IOException {
        return this.advanceUpToNextValueChar() == 'n';
    }

    public boolean nextBoolean() throws IOException {
        char c = this.advanceUpToNextValueChar();
        if (c == 't') {
            String value = this.readLiteral(4);
            if (!"true".equals(value)) {
                throw this.unexpectedSyntaxError("'true'", value);
            }
            return true;
        }
        if (c == 'f') {
            String value = this.readLiteral(5);
            if (!"false".equals(value)) {
                throw this.unexpectedSyntaxError("'false'", value);
            }
            return false;
        }
        throw this.unexpectedSyntaxError("'true' or 'false", c);
    }

    public String nextString() throws IOException {
        char c = this.advanceUpToNextValueChar();
        if (c != '\"') {
            throw this.unexpectedSyntaxError("'\"'", c);
        }
        return this.readString();
    }

    public int nextInt() throws IOException {
        String number = this.readNumber();
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw this.unexpectedSyntaxError("an integer", number);
        }
    }

    public long nextLong() throws IOException {
        String number = this.readNumber();
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            throw this.unexpectedSyntaxError("a long", number);
        }
    }

    public double nextDouble() throws IOException {
        String number = this.readNumber();
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            throw this.unexpectedSyntaxError("a double", number);
        }
    }

    public boolean hasNext() throws IOException {
        this.consumeWhitespace();
        char c = this.peek();
        return c != ']' && c != '}';
    }

    public Object nextValue() throws IOException {
        char c = this.advanceUpToNextValueChar();
        switch (c) {
            case '\"': {
                return this.nextString();
            }
            case '{': {
                String name;
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.beginObject();
                while ((name = this.nextName()) != null) {
                    map.put(name, this.nextValue());
                }
                this.endObject();
                return map;
            }
            case '[': {
                ArrayList<Object> list = new ArrayList<Object>();
                this.beginArray();
                while (this.hasNext()) {
                    list.add(this.nextValue());
                }
                this.endArray();
                return list;
            }
            case 'f': 
            case 't': {
                return this.nextBoolean();
            }
            case 'n': {
                this.readLiteral(4);
                return null;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                String number = this.readNumber();
                if (!(number.contains(".") || number.contains("e") || number.contains("E"))) {
                    try {
                        return Integer.parseInt(number);
                    }
                    catch (NumberFormatException e) {
                        try {
                            return Long.parseLong(number);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                return Double.parseDouble(number);
            }
        }
        throw this.syntaxError("Unexpected character: " + c);
    }

    private char advanceUpToNextValueChar() throws IOException {
        this.consumeWhitespace();
        char c = this.peek();
        if (c == ',') {
            this.advance();
            this.consumeWhitespace();
            c = this.peek();
        }
        return c;
    }

    private void consumeWhitespace() throws IOException {
        char c;
        while ((c = this.peek()) == ' ' || c == '\n' || c == '\r' || c == '\t') {
            this.advance();
            if (c != '\n') continue;
            ++this.lineNumber;
            this.linePosition = 0;
        }
    }

    private char peek() throws IOException {
        if (this.position >= this.limit) {
            this.fillBuffer();
        }
        return this.position < this.limit ? this.buffer[this.position] : (char)'\u0000';
    }

    private void advance() throws IOException {
        if (this.position >= this.limit) {
            this.fillBuffer();
        }
        if (this.position < this.limit) {
            ++this.position;
            ++this.linePosition;
        }
    }

    private void fillBuffer() throws IOException {
        this.limit = this.reader.read(this.buffer, 0, this.buffer.length);
        this.position = 0;
        if (this.limit == -1) {
            this.limit = 0;
        }
    }

    private String readString() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.advance();
        block9: while (true) {
            block12: {
                char c;
                block11: {
                    if ((c = this.peek()) == '\"') break;
                    if (c != '\\') break block11;
                    this.advance();
                    c = this.peek();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            break block12;
                        }
                        case 'b': {
                            sb.append('\b');
                            break block12;
                        }
                        case 'f': {
                            sb.append('\f');
                            break block12;
                        }
                        case 'n': {
                            sb.append('\n');
                            break block12;
                        }
                        case 'r': {
                            sb.append('\r');
                            break block12;
                        }
                        case 't': {
                            sb.append('\t');
                            break block12;
                        }
                        case 'u': {
                            sb.append(this.readUnicodeEscape());
                            continue block9;
                        }
                        default: {
                            throw this.syntaxError("Invalid escape sequence: \\" + c);
                        }
                    }
                }
                if (c < ' ') {
                    throw this.syntaxError("Unterminated string");
                }
                sb.append(c);
            }
            this.advance();
        }
        this.advance();
        return sb.toString();
    }

    private char readUnicodeEscape() throws IOException {
        this.advance();
        StringBuilder hex = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            hex.append(this.peek());
            this.advance();
        }
        try {
            return (char)Integer.parseInt(hex.toString(), 16);
        }
        catch (NumberFormatException e) {
            throw this.syntaxError("Invalid unicode escape sequence: \\u" + hex);
        }
    }

    private String readNumber() throws IOException {
        StringBuilder sb = new StringBuilder();
        char c = this.peek();
        if (c == '-') {
            sb.append(c);
            this.advance();
        }
        this.readDigits(sb);
        if (this.peek() == '.') {
            sb.append('.');
            this.advance();
            this.readDigits(sb);
        }
        if ((c = this.peek()) == 'e' || c == 'E') {
            sb.append(c);
            this.advance();
            c = this.peek();
            if (c == '+' || c == '-') {
                sb.append(c);
                this.advance();
            }
            this.readDigits(sb);
        }
        return sb.toString();
    }

    private void readDigits(StringBuilder sb) throws IOException {
        char c = this.peek();
        if (c < '0' || c > '9') {
            throw this.unexpectedSyntaxError("digit", c);
        }
        while ((c = this.peek()) >= '0' && c <= '9') {
            sb.append(c);
            this.advance();
        }
    }

    private String readLiteral(int length) throws IOException {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(this.peek());
            this.advance();
        }
        return sb.toString();
    }

    private IOException unexpectedSyntaxError(String expected, String found) {
        return new IOException(String.format("Syntax error at line %d, position %d: expected %s but found '%s'", this.lineNumber, this.linePosition, expected, found));
    }

    private IOException unexpectedSyntaxError(String expected, char found) {
        return new IOException(String.format("Syntax error at line %d, position %d: expected %s but found '%s'", this.lineNumber, this.linePosition, expected, Character.valueOf(found)));
    }

    private IOException syntaxError(String message) {
        return new IOException(String.format("Syntax error at line %d, position %d: %s", this.lineNumber, this.linePosition, message));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

