/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class JVM {
    private static final int JAVA_VERSION = JVM.getMajorJavaVersion();
    private static final int BUFFER_SIZE = 8192;

    private JVM() {
    }

    public static boolean atLeastJava(int expectedVersion) {
        return expectedVersion <= JAVA_VERSION;
    }

    private static int getMajorJavaVersion() {
        try {
            return JVM.parseMajorJavaVersion(System.getProperty("java.version"));
        }
        catch (Throwable e1) {
            try {
                return Runtime.version().major();
            }
            catch (Throwable e2) {
                return 8;
            }
        }
    }

    private static int parseMajorJavaVersion(String str) {
        int value = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                value = value * 10 + (ch - 48);
                continue;
            }
            if (ch == '.') {
                if (value != 1) break;
                value = 0;
                continue;
            }
            throw new NumberFormatException();
        }
        return value;
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        if (JVM.atLeastJava(9)) {
            return is.readAllBytes();
        }
        return JVM.readAllBytesLoop(is);
    }

    private static byte[] readAllBytesLoop(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buf = new byte[8192];
            while ((bytesRead = is.read(buf, 0, 8192)) != -1) {
                os.write(buf, 0, bytesRead);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }
}

