/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.InternalMatchers;
import datadog.instrument.classmatch.InternalNames;
import datadog.instrument.classmatch.TypeString;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;

@FunctionalInterface
public interface TypeMatcher
extends Predicate<CharSequence> {
    public static TypeMatcher type(String type) {
        return InternalMatchers.internalName(type)::contentEquals;
    }

    public static TypeMatcher typeOneOf(String ... types) {
        return TypeMatcher.typeOneOf(Arrays.asList(types));
    }

    public static TypeMatcher typeOneOf(Collection<String> types) {
        return new InternalNames(types)::containsType;
    }

    public static TypeMatcher typeStartsWith(String prefix) {
        String internalPrefix = InternalMatchers.internalName(prefix);
        return cs -> TypeString.startsWith(cs, internalPrefix);
    }

    public static TypeMatcher typeEndsWith(String suffix) {
        String internalSuffix = InternalMatchers.internalName(suffix);
        return cs -> TypeString.endsWith(cs, internalSuffix);
    }

    default public TypeMatcher and(TypeMatcher other) {
        return new InternalMatchers.TypeConjunction(this, other);
    }

    default public TypeMatcher or(TypeMatcher other) {
        return new InternalMatchers.TypeDisjunction(this, other);
    }
}

