/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classinject;

import datadog.instrument.asm.ClassReader;
import datadog.instrument.asm.ClassVisitor;
import datadog.instrument.asm.ClassWriter;
import datadog.instrument.asm.Label;
import datadog.instrument.asm.MethodVisitor;
import datadog.instrument.asm.Type;
import datadog.instrument.utils.JVM;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public final class ClassInjector {
    private static volatile BiFunction defineClassGlue;

    public static Class<?> injectBootClass(String name, byte[] bytecode) {
        return ClassInjector.injectBootClasses(Collections.singletonMap(name, bytecode)).get(0);
    }

    public static Class<?> injectClass(String name, byte[] bytecode, ClassLoader cl) {
        return ClassInjector.injectClasses(Collections.singletonMap(name, bytecode), cl).get(0);
    }

    public static Class<?> injectClass(String name, byte[] bytecode, ProtectionDomain pd) {
        return ClassInjector.injectClasses(Collections.singletonMap(name, bytecode), pd).get(0);
    }

    public static List<Class<?>> injectBootClasses(Map<String, byte[]> bytecode) {
        return (List)ClassInjector.classDefiner().apply(bytecode, null);
    }

    public static List<Class<?>> injectClasses(Map<String, byte[]> bytecode, ClassLoader cl) {
        return (List)ClassInjector.classDefiner().apply(bytecode, cl);
    }

    public static List<Class<?>> injectClasses(Map<String, byte[]> bytecode, ProtectionDomain pd) {
        return (List)ClassInjector.classDefiner().apply(bytecode, pd);
    }

    private ClassInjector() {
    }

    private static BiFunction classDefiner() {
        if (defineClassGlue == null) {
            throw new IllegalStateException("Class injection not enabled");
        }
        return defineClassGlue;
    }

    public static void enableClassInjection(Instrumentation inst) {
        if (defineClassGlue == null) {
            try {
                defineClassGlue = ClassInjector.injectViaLoadClass(inst);
            }
            catch (Throwable ignore) {
                try {
                    defineClassGlue = ClassInjector.injectViaForName(inst);
                }
                catch (Throwable e) {
                    throw new UnsupportedOperationException("Class injection not available", e);
                }
            }
        }
    }

    private static BiFunction injectViaLoadClass(Instrumentation inst) throws Exception {
        BiFunction biFunction;
        InjectGlue injectGlue = new InjectGlue("java/lang/ClassLoader", "loadClass");
        try {
            inst.addTransformer(injectGlue, true);
            inst.retransformClasses(ClassLoader.class);
            biFunction = (BiFunction)ClassLoader.getSystemClassLoader().loadClass("java.lang.$Datadog$DefineClassGlue").newInstance();
            inst.removeTransformer(injectGlue);
        }
        catch (Throwable throwable) {
            inst.removeTransformer(injectGlue);
            inst.retransformClasses(ClassLoader.class);
            throw throwable;
        }
        inst.retransformClasses(ClassLoader.class);
        return biFunction;
    }

    private static BiFunction injectViaForName(Instrumentation inst) throws Exception {
        BiFunction biFunction;
        InjectGlue injectGlue = new InjectGlue("java/lang/Class", "forName");
        try {
            inst.addTransformer(injectGlue, true);
            inst.retransformClasses(Class.class);
            biFunction = (BiFunction)Class.forName("java.lang.$Datadog$DefineClassGlue").newInstance();
            inst.removeTransformer(injectGlue);
        }
        catch (Throwable throwable) {
            inst.removeTransformer(injectGlue);
            inst.retransformClasses(Class.class);
            throw throwable;
        }
        inst.retransformClasses(Class.class);
        return biFunction;
    }

    static final class InjectGlue
    implements ClassFileTransformer {
        private final String targetClass;
        private final String targetMethod;

        InjectGlue(String targetClass, String targetMethod) {
            this.targetClass = targetClass;
            this.targetMethod = targetMethod;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) {
            if (this.targetClass.equals(className)) {
                ClassReader cr = new ClassReader(bytecode);
                ClassWriter cw = new ClassWriter(cr, 0);
                cr.accept(new ClassPatch(cw, this.targetMethod), 0);
                return cw.toByteArray();
            }
            return null;
        }
    }

    static final class MethodPatch
    extends MethodVisitor {
        private final int access;

        MethodPatch(MethodVisitor mv, int access) {
            super(589824, mv);
            this.access = access;
        }

        @Override
        public void visitCode() {
            this.mv.visitCode();
            Label notDatadogGlueRequest = new Label();
            this.mv.visitLdcInsn("java.lang.$Datadog$DefineClassGlue");
            this.mv.visitVarInsn(25, (this.access & 8) != 0 ? 0 : 1);
            this.mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(153, notDatadogGlueRequest);
            if (JVM.atLeastJava(15)) {
                this.mv.visitMethodInsn(184, "java/lang/invoke/MethodHandles", "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", false);
                this.mv.visitLdcInsn("\ucafe\ubabe\u00004^\u0100\u226a\u6176\u612f\u6c61\u6e67\u2f24\u4461\u7461\u646f\u6724\u4465\u6669\u6e65\u436c\u6173\u7347\u6c75\u6507\u0001\u0100\u106a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u7407\u0003\u0100\u1d6a\u6176\u612f\u7574\u696c\u2f66\u756e\u6374\u696f\u6e2f\u4269\u4675\u6e63\u7469\u6f6e\u0700\u0501\u0006\u554e\u5341\u4645\u0100\u1a4c\u6a64\u6b2f\u696e\u7465\u726e\u616c\u2f6d\u6973\u632f\u556e\u7361\u6665\u3b01\b\u3c63\u6c69\u6e69\u743e\u0100\u0328\u2956\u0100\u186a\u646b\u2f69\u6e74\u6572\u6e61\u6c2f\u6d69\u7363\u2f55\u6e73\u6166\u6507\u000b\u0100\u0967\u6574\u556e\u7361\u6665\u0100\u1c28\u294c\u6a64\u6b2f\u696e\u7465\u726e\u616c\u2f6d\u6973\u632f\u556e\u7361\u6665\u3b0c\r\u000e\u0a00\u0c00\u0f0c\u0007\b\u0900\u0200\u1101\u0006\u3c69\u6e69\u743e\u0c00\u1300\u0a0a\u0004\u0014\u0100\u0561\u7070\u6c79\u0100\u3828\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b01\u0013\u6a61\u7661\u2f75\u7469\u6c2f\u4172\u7261\u794c\u6973\u7407\u0018\u0a00\u1900\u1401\r\u6a61\u7661\u2f75\u7469\u6c2f\u4d61\u7007\u001b\u0100\u0865\u6e74\u7279\u5365\u7401\u0011\u2829\u4c6a\u6176\u612f\u7574\u696c\u2f53\u6574\u3b0c\u001d\u001e\u0b00\u1c00\u1f01\r\u6a61\u7661\u2f75\u7469\u6c2f\u5365\u7407!\u0100\u0869\u7465\u7261\u746f\u7201\u0016\u2829\u4c6a\u6176\u612f\u7574\u696c\u2f49\u7465\u7261\u746f\u723b\u0c00\u2300\u240b\"%\u0100\u1e6a\u6176\u612f\u7365\u6375\u7269\u7479\u2f50\u726f\u7465\u6374\u696f\u6e44\u6f6d\u6169\u6e07'\u0100\u0e67\u6574\u436c\u6173\u734c\u6f61\u6465\u7201\u0019\u2829\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u4c6f\u6164\u6572\u3b0c)*\u0a00\u2800\u2b01\u0015\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u734c\u6f61\u6465\u7207-\u0100\u126a\u6176\u612f\u7574\u696c\u2f49\u7465\u7261\u746f\u7207/\u0100\u0768\u6173\u4e65\u7874\u0100\u0328\u295a\u0c00\u3100\u320b03\u0100\u046e\u6578\u7401\u0014\u2829\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u0c00\u3500\u360b07\u0100\u136a\u6176\u612f\u7574\u696c\u2f4d\u6170\u2445\u6e74\u7279\u0700\u3901\u0006\u6765\u744b\u6579\u0c00\u3b00\u360b:<\u0100\u106a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u6707>\u0100\u1367\u6574\u436c\u6173\u734c\u6f61\u6469\u6e67\u4c6f\u636b\u0100\u2628\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b0c@A\u0a00\u2e00\u4201\u000f\u6669\u6e64\u4c6f\u6164\u6564\u436c\u6173\u7301%\u284c\u6a61\u7661\u2f6c\u616e\u672f\u5374\u7269\u6e67\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u3b0cDE\u0a00\u2e00\u4601\b\u6765\u7456\u616c\u7565\u0c00\u4800\u360b:I\u0100\u025b\u4207K\u0100\u0b64\u6566\u696e\u6543\u6c61\u7373\u0100\u4928\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u5b42\u4949\u4c6a\u6176\u612f\u7365\u6375\u7269\u7479\u2f50\u726f\u7465\u6374\u696f\u6e44\u6f6d\u6169\u6e3b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u733b\u0c00\u4d00\u4e0a.O\u0100\u0361\u6464\u0100\u1528\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u295a\u0c00\u5100\u520a\u0019S\u0100\u6028\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u5b42\u4949\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u4c6f\u6164\u6572\u3b4c\u6a61\u7661\u2f73\u6563\u7572\u6974\u792f\u5072\u6f74\u6563\u7469\u6f6e\u446f\u6d61\u696e\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u3b0cMU\u0a00\u0c00\u5601\u000f\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u7307X\u0100\u136a\u6176\u612f\u6c61\u6e67\u2f54\u6872\u6f77\u6162\u6c65\u0700\u5a01\u0004\u436f\u6465\u0100\u0d53\u7461\u636b\u4d61\u7054\u6162\u6c65\u0011\u0002\u0004\u0001\u0006\u0001\u001a\u0007\b\u0000\u0003\b\t\n\u0001\\\u0000\u0013\u0001\u0000\u0000\u0007\ub800\u10b3\u0012\ub100\u0000\u0000\u0100\u1300\u0a00\u0100\u5c00\u0000\u1100\u0100\u0100\u0000\u052a\ub700\u15b1\u0000\u0000\u0001\u0016\u0017\u0001\\\u0000\u013c\u0007\n\u0000\u00d5\ubb00\u1959\ub700\u1a4e\u2bb9 \u0100\ub900\u2601:\u042c\uc100\u2899\u0012\u2cc0(\u593a\u05b6,\u3a06\ua700\u0c01\u3a05\u2cc0.\u3a06\u1906\uc600\u6019\u04b94\u0100\u9900\u9319\u04b98\u0100\u593a\u08b9=\u0100\uc000\u3f3a\u0919\u0619\u09b6C\u593a\u07c2\u1906\u1909\ub600\u4759\uc700\u1b57\u1906\u1909\u1908\ub900\u4a01\u00c0L\u59be\u035f\u1905\ub600\u502d\u5fb6T\u5719\u07c3\ua7ff\uab59\u1907\uc3bf\ub200\u123a\u0719\u04b94\u0100\u9900\u3119\u0719\u04b98\u0100\u59b9=\u0100\uc000\u3f5f\ub900\u4a01\u00c0L\u59be\u035f\u0119\u05b6W\u2d5f\ub600\u5457\ua7ff\ucb2d\ub000\u0100\u6200\u8e00\u9100\u0000\u0100\u5d00\u0000\u4d00\u08fd+\u0700\u19070\ufd00\u0807(\u0700\u2e04\uff00\u4b00\u0a07\u0002\u0700\u0407\u0004\u0700\u19070\u0700\u2807.\u0700\u0407\u0004\u0700\u3f00\u0107Y\u4b07[\uf800\u04fc\u0004\u0700\u0cfa7\u0000");
            } else if (JVM.atLeastJava(9)) {
                this.mv.visitMethodInsn(184, "jdk/internal/misc/Unsafe", "getUnsafe", "()Ljdk/internal/misc/Unsafe;", false);
                this.mv.visitLdcInsn(Type.getType(ClassLoader.class));
                this.mv.visitLdcInsn("\ucafe\ubabe\u00004^\u0100\u226a\u6176\u612f\u6c61\u6e67\u2f24\u4461\u7461\u646f\u6724\u4465\u6669\u6e65\u436c\u6173\u7347\u6c75\u6507\u0001\u0100\u106a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u7407\u0003\u0100\u1d6a\u6176\u612f\u7574\u696c\u2f66\u756e\u6374\u696f\u6e2f\u4269\u4675\u6e63\u7469\u6f6e\u0700\u0501\u0006\u554e\u5341\u4645\u0100\u1a4c\u6a64\u6b2f\u696e\u7465\u726e\u616c\u2f6d\u6973\u632f\u556e\u7361\u6665\u3b01\b\u3c63\u6c69\u6e69\u743e\u0100\u0328\u2956\u0100\u186a\u646b\u2f69\u6e74\u6572\u6e61\u6c2f\u6d69\u7363\u2f55\u6e73\u6166\u6507\u000b\u0100\u0967\u6574\u556e\u7361\u6665\u0100\u1c28\u294c\u6a64\u6b2f\u696e\u7465\u726e\u616c\u2f6d\u6973\u632f\u556e\u7361\u6665\u3b0c\r\u000e\u0a00\u0c00\u0f0c\u0007\b\u0900\u0200\u1101\u0006\u3c69\u6e69\u743e\u0c00\u1300\u0a0a\u0004\u0014\u0100\u0561\u7070\u6c79\u0100\u3828\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b01\u0013\u6a61\u7661\u2f75\u7469\u6c2f\u4172\u7261\u794c\u6973\u7407\u0018\u0a00\u1900\u1401\r\u6a61\u7661\u2f75\u7469\u6c2f\u4d61\u7007\u001b\u0100\u0865\u6e74\u7279\u5365\u7401\u0011\u2829\u4c6a\u6176\u612f\u7574\u696c\u2f53\u6574\u3b0c\u001d\u001e\u0b00\u1c00\u1f01\r\u6a61\u7661\u2f75\u7469\u6c2f\u5365\u7407!\u0100\u0869\u7465\u7261\u746f\u7201\u0016\u2829\u4c6a\u6176\u612f\u7574\u696c\u2f49\u7465\u7261\u746f\u723b\u0c00\u2300\u240b\"%\u0100\u1e6a\u6176\u612f\u7365\u6375\u7269\u7479\u2f50\u726f\u7465\u6374\u696f\u6e44\u6f6d\u6169\u6e07'\u0100\u0e67\u6574\u436c\u6173\u734c\u6f61\u6465\u7201\u0019\u2829\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u4c6f\u6164\u6572\u3b0c)*\u0a00\u2800\u2b01\u0015\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u734c\u6f61\u6465\u7207-\u0100\u126a\u6176\u612f\u7574\u696c\u2f49\u7465\u7261\u746f\u7207/\u0100\u0768\u6173\u4e65\u7874\u0100\u0328\u295a\u0c00\u3100\u320b03\u0100\u046e\u6578\u7401\u0014\u2829\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u0c00\u3500\u360b07\u0100\u136a\u6176\u612f\u7574\u696c\u2f4d\u6170\u2445\u6e74\u7279\u0700\u3901\u0006\u6765\u744b\u6579\u0c00\u3b00\u360b:<\u0100\u106a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u6707>\u0100\u1367\u6574\u436c\u6173\u734c\u6f61\u6469\u6e67\u4c6f\u636b\u0100\u2628\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b0c@A\u0a00\u2e00\u4201\u000f\u6669\u6e64\u4c6f\u6164\u6564\u436c\u6173\u7301%\u284c\u6a61\u7661\u2f6c\u616e\u672f\u5374\u7269\u6e67\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u3b0cDE\u0a00\u2e00\u4601\b\u6765\u7456\u616c\u7565\u0c00\u4800\u360b:I\u0100\u025b\u4207K\u0100\u0b64\u6566\u696e\u6543\u6c61\u7373\u0100\u4928\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u5b42\u4949\u4c6a\u6176\u612f\u7365\u6375\u7269\u7479\u2f50\u726f\u7465\u6374\u696f\u6e44\u6f6d\u6169\u6e3b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u733b\u0c00\u4d00\u4e0a.O\u0100\u0361\u6464\u0100\u1528\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u295a\u0c00\u5100\u520a\u0019S\u0100\u6028\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u5b42\u4949\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u4c6f\u6164\u6572\u3b4c\u6a61\u7661\u2f73\u6563\u7572\u6974\u792f\u5072\u6f74\u6563\u7469\u6f6e\u446f\u6d61\u696e\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u3b0cMU\u0a00\u0c00\u5601\u000f\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u7307X\u0100\u136a\u6176\u612f\u6c61\u6e67\u2f54\u6872\u6f77\u6162\u6c65\u0700\u5a01\u0004\u436f\u6465\u0100\u0d53\u7461\u636b\u4d61\u7054\u6162\u6c65\u0011\u0002\u0004\u0001\u0006\u0001\u001a\u0007\b\u0000\u0003\b\t\n\u0001\\\u0000\u0013\u0001\u0000\u0000\u0007\ub800\u10b3\u0012\ub100\u0000\u0000\u0100\u1300\u0a00\u0100\u5c00\u0000\u1100\u0100\u0100\u0000\u052a\ub700\u15b1\u0000\u0000\u0001\u0016\u0017\u0001\\\u0000\u013c\u0007\n\u0000\u00d5\ubb00\u1959\ub700\u1a4e\u2bb9 \u0100\ub900\u2601:\u042c\uc100\u2899\u0012\u2cc0(\u593a\u05b6,\u3a06\ua700\u0c01\u3a05\u2cc0.\u3a06\u1906\uc600\u6019\u04b94\u0100\u9900\u9319\u04b98\u0100\u593a\u08b9=\u0100\uc000\u3f3a\u0919\u0619\u09b6C\u593a\u07c2\u1906\u1909\ub600\u4759\uc700\u1b57\u1906\u1909\u1908\ub900\u4a01\u00c0L\u59be\u035f\u1905\ub600\u502d\u5fb6T\u5719\u07c3\ua7ff\uab59\u1907\uc3bf\ub200\u123a\u0719\u04b94\u0100\u9900\u3119\u0719\u04b98\u0100\u59b9=\u0100\uc000\u3f5f\ub900\u4a01\u00c0L\u59be\u035f\u0119\u05b6W\u2d5f\ub600\u5457\ua7ff\ucb2d\ub000\u0100\u6200\u8e00\u9100\u0000\u0100\u5d00\u0000\u4d00\u08fd+\u0700\u19070\ufd00\u0807(\u0700\u2e04\uff00\u4b00\u0a07\u0002\u0700\u0407\u0004\u0700\u19070\u0700\u2807.\u0700\u0407\u0004\u0700\u3f00\u0107Y\u4b07[\uf800\u04fc\u0004\u0700\u0cfa7\u0000");
            } else {
                this.mv.visitMethodInsn(184, "sun/misc/Unsafe", "getUnsafe", "()Lsun/misc/Unsafe;", false);
                this.mv.visitLdcInsn(Type.getType(ClassLoader.class));
                this.mv.visitLdcInsn("\ucafe\ubabe\u00004_\u0100\u226a\u6176\u612f\u6c61\u6e67\u2f24\u4461\u7461\u646f\u6724\u4465\u6669\u6e65\u436c\u6173\u7347\u6c75\u6507\u0001\u0100\u106a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u7407\u0003\u0100\u1d6a\u6176\u612f\u7574\u696c\u2f66\u756e\u6374\u696f\u6e2f\u4269\u4675\u6e63\u7469\u6f6e\u0700\u0501\u0006\u554e\u5341\u4645\u0100\u114c\u7375\u6e2f\u6d69\u7363\u2f55\u6e73\u6166\u653b\u0100\u083c\u636c\u696e\u6974\u3e01\u0003\u2829\u5601\u000f\u7375\u6e2f\u6d69\u7363\u2f55\u6e73\u6166\u6507\u000b\u0100\u0967\u6574\u556e\u7361\u6665\u0100\u1328\u294c\u7375\u6e2f\u6d69\u7363\u2f55\u6e73\u6166\u653b\u0c00\u0d00\u0e0a\f\u000f\u0c00\u0700\u0809\u0002\u0011\u0100\u063c\u696e\u6974\u3e0c\u0013\n\u0a00\u0400\u1401\u0005\u6170\u706c\u79018\u284c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b4c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u0100\u136a\u6176\u612f\u7574\u696c\u2f41\u7272\u6179\u4c69\u7374\u0700\u180a\u0019\u0014\u0100\u0d6a\u6176\u612f\u7574\u696c\u2f4d\u6170\u0700\u1b01\b\u656e\u7472\u7953\u6574\u0100\u1128\u294c\u6a61\u7661\u2f75\u7469\u6c2f\u5365\u743b\u0c00\u1d00\u1e0b\u001c\u001f\u0100\u0d6a\u6176\u612f\u7574\u696c\u2f53\u6574\u0700\u2101\b\u6974\u6572\u6174\u6f72\u0100\u1628\u294c\u6a61\u7661\u2f75\u7469\u6c2f\u4974\u6572\u6174\u6f72\u3b0c#$\u0b00\u2200\u2501\u001e\u6a61\u7661\u2f73\u6563\u7572\u6974\u792f\u5072\u6f74\u6563\u7469\u6f6e\u446f\u6d61\u696e\u0700\u2701\u000e\u6765\u7443\u6c61\u7373\u4c6f\u6164\u6572\u0100\u1928\u294c\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u734c\u6f61\u6465\u723b\u0c00\u2900\u2a0a(+\u0100\u156a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u4c6f\u6164\u6572\u0700\u2d01\u0012\u6a61\u7661\u2f75\u7469\u6c2f\u4974\u6572\u6174\u6f72\u0700\u2f01\u0007\u6861\u734e\u6578\u7401\u0003\u2829\u5a0c12\u0b00\u3000\u3301\u0004\u6e65\u7874\u0100\u1428\u294c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b0c56\u0b00\u3000\u3701\u0013\u6a61\u7661\u2f75\u7469\u6c2f\u4d61\u7024\u456e\u7472\u79079\u0100\u0667\u6574\u4b65\u790c;6\u0b00\u3a00\u3c01\u0010\u6a61\u7661\u2f6c\u616e\u672f\u5374\u7269\u6e67\u0700\u3e01\u0013\u6765\u7443\u6c61\u7373\u4c6f\u6164\u696e\u674c\u6f63\u6b01&\u284c\u6a61\u7661\u2f6c\u616e\u672f\u5374\u7269\u6e67\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f4f\u626a\u6563\u743b\u0c00\u4000\u410a.B\u0100\u0f66\u696e\u644c\u6f61\u6465\u6443\u6c61\u7373\u0100\u2528\u4c6a\u6176\u612f\u6c61\u6e67\u2f53\u7472\u696e\u673b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u733b\u0c00\u4400\u450a.F\u0100\u0867\u6574\u5661\u6c75\u650cH6\u0b00\u3a00\u4901\u0002\u5b42\u0700\u4b01\u000b\u6465\u6669\u6e65\u436c\u6173\u7301I\u284c\u6a61\u7661\u2f6c\u616e\u672f\u5374\u7269\u6e67\u3b5b\u4249\u494c\u6a61\u7661\u2f73\u6563\u7572\u6974\u792f\u5072\u6f74\u6563\u7469\u6f6e\u446f\u6d61\u696e\u3b29\u4c6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u3b0cMN\u0a00\u2e00\u4f01\u0003\u6164\u6401\u0015\u284c\u6a61\u7661\u2f6c\u616e\u672f\u4f62\u6a65\u6374\u3b29\u5a0cQR\u0a00\u1900\u5301`\u284c\u6a61\u7661\u2f6c\u616e\u672f\u5374\u7269\u6e67\u3b5b\u4249\u494c\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u734c\u6f61\u6465\u723b\u4c6a\u6176\u612f\u7365\u6375\u7269\u7479\u2f50\u726f\u7465\u6374\u696f\u6e44\u6f6d\u6169\u6e3b\u294c\u6a61\u7661\u2f6c\u616e\u672f\u436c\u6173\u733b\u0c00\u4d00\u550a\fV\u0100\u0f6a\u6176\u612f\u6c61\u6e67\u2f43\u6c61\u7373\u0700\u5801\u0013\u6a61\u7661\u2f6c\u616e\u672f\u5468\u726f\u7761\u626c\u6507Z\u0300\u0000\u0001\u0004\u436f\u6465\u0100\u0d53\u7461\u636b\u4d61\u7054\u6162\u6c65\u0011\u0002\u0004\u0001\u0006\u0001\u001a\u0007\b\u0000\u0003\b\t\n\u0001]\u0000\u0013\u0001\u0000\u0000\u0007\ub800\u10b3\u0012\ub100\u0000\u0000\u0100\u1300\u0a00\u0100\u5d00\u0000\u1100\u0100\u0100\u0000\u052a\ub700\u15b1\u0000\u0000\u0001\u0016\u0017\u0001]\u0000\u013c\u0007\n\u0000\u00d5\ubb00\u1959\ub700\u1a4e\u2bb9 \u0100\ub900\u2601:\u042c\uc100\u2899\u0012\u2cc0(\u593a\u05b6,\u3a06\ua700\u0c01\u3a05\u2cc0.\u3a06\u1906\uc600\u6019\u04b94\u0100\u9900\u9319\u04b98\u0100\u593a\u08b9=\u0100\uc000\u3f3a\u0919\u0619\u09b6C\u593a\u07c2\u1906\u1909\ub600\u4759\uc700\u1b57\u1906\u1909\u1908\ub900\u4a01\u00c0L\u59be\u035f\u1905\ub600\u502d\u5fb6T\u5719\u07c3\ua7ff\uab59\u1907\uc3bf\ub200\u123a\u0719\u04b94\u0100\u9900\u3119\u0719\u04b98\u0100\u59b9=\u0100\uc000\u3f5f\ub900\u4a01\u00c0L\u59be\u035f\u0119\u05b6W\u2d5f\ub600\u5457\ua7ff\ucb2d\ub000\u0100\u6200\u8e00\u9100\u0000\u0100\u5e00\u0000\u4d00\u08fd+\u0700\u19070\ufd00\u0807(\u0700\u2e04\uff00\u4b00\u0a07\u0002\u0700\u0407\u0004\u0700\u19070\u0700\u2807.\u0700\u0407\u0004\u0700\u3f00\u0107Y\u4b07[\uf800\u04fc\u0004\u0700\u0cfa7\u0000");
            }
            this.mv.visitFieldInsn(178, "java/nio/charset/StandardCharsets", "UTF_16BE", "Ljava/nio/charset/Charset;");
            this.mv.visitMethodInsn(182, "java/lang/String", "getBytes", "(Ljava/nio/charset/Charset;)[B", false);
            if (JVM.atLeastJava(15)) {
                this.mv.visitInsn(3);
                this.mv.visitInsn(3);
                this.mv.visitTypeInsn(189, "java/lang/invoke/MethodHandles$Lookup$ClassOption");
                this.mv.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "defineHiddenClass", "([BZ[Ljava/lang/invoke/MethodHandles$Lookup$ClassOption;)Ljava/lang/invoke/MethodHandles$Lookup;", false);
                this.mv.visitMethodInsn(182, "java/lang/invoke/MethodHandles$Lookup", "lookupClass", "()Ljava/lang/Class;", false);
            } else if (JVM.atLeastJava(9)) {
                this.mv.visitInsn(1);
                this.mv.visitMethodInsn(182, "jdk/internal/misc/Unsafe", "defineAnonymousClass", "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;", false);
            } else {
                this.mv.visitInsn(1);
                this.mv.visitMethodInsn(182, "sun/misc/Unsafe", "defineAnonymousClass", "(Ljava/lang/Class;[B[Ljava/lang/Object;)Ljava/lang/Class;", false);
            }
            this.mv.visitInsn(176);
            this.mv.visitLabel(notDatadogGlueRequest);
            this.mv.visitFrame(3, 0, null, 0, null);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            this.mv.visitMaxs(Math.max(maxStack, 4), maxLocals);
        }
    }

    static final class ClassPatch
    extends ClassVisitor {
        private final String targetMethod;

        ClassPatch(ClassVisitor cv, String targetMethod) {
            super(589824, cv);
            this.targetMethod = targetMethod;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, descriptor, signature, exceptions);
            if (this.targetMethod.equals(name) && descriptor.startsWith("(Ljava/lang/String;") && descriptor.endsWith(")Ljava/lang/Class;")) {
                return new MethodPatch(mv, access);
            }
            return mv;
        }
    }
}

