/*
 * Decompiled with CFR 0.152.
 */
package datadog.context;

import datadog.context.Context;
import datadog.context.ContextKey;
import datadog.context.EmptyContext;
import datadog.context.IndexedContext;
import datadog.context.SingletonContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;

public final class ContextHelpers {
    public static final Object CURRENT = new Object();

    private ContextHelpers() {
    }

    public static <T> T findFirst(ContextKey<T> key, Object ... carriers) {
        Objects.requireNonNull(key, "key cannot be null");
        for (Object carrier : carriers) {
            Objects.requireNonNull(carrier, "carrier cannot be null");
            Context context = carrier == CURRENT ? Context.current() : Context.from(carrier);
            T value = context.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static <T> List<T> findAll(ContextKey<T> key, Object ... carriers) {
        Objects.requireNonNull(key, "key cannot be null");
        ArrayList<T> values = new ArrayList<T>(carriers.length);
        for (Object carrier : carriers) {
            Objects.requireNonNull(carrier, "carrier cannot be null");
            Context context = carrier == CURRENT ? Context.current() : Context.from(carrier);
            T value = context.get(key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static Context combine(Context ... contexts) {
        return ContextHelpers.combine(ContextHelpers::combineKeepingFirst, contexts);
    }

    public static Context combine(BinaryOperator<Context> combiner, Context ... contexts) {
        Objects.requireNonNull(combiner, "combiner cannot be null");
        Context result = new IndexedContext(new Object[0]);
        for (Context context : contexts) {
            Objects.requireNonNull(context, "context cannot be null");
            result = (Context)combiner.apply(result, context);
        }
        return result;
    }

    private static Context combineKeepingFirst(Context current, Context next) {
        if (!(current instanceof IndexedContext)) {
            throw new IllegalStateException("Left context is supposed to be an IndexedContext");
        }
        IndexedContext currentIndexed = (IndexedContext)current;
        if (next instanceof EmptyContext) {
            return current;
        }
        if (next instanceof SingletonContext) {
            SingletonContext nextSingleton = (SingletonContext)next;
            if (nextSingleton.index < currentIndexed.store.length && currentIndexed.store[nextSingleton.index] != null) {
                return current;
            }
            Object[] store = Arrays.copyOfRange(currentIndexed.store, 0, Math.max(currentIndexed.store.length, nextSingleton.index + 1));
            store[nextSingleton.index] = nextSingleton.value;
            return new IndexedContext(store);
        }
        if (next instanceof IndexedContext) {
            Object nextValue;
            int i;
            IndexedContext nextIndexed = (IndexedContext)next;
            Object[] store = null;
            if (nextIndexed.store.length > currentIndexed.store.length) {
                store = Arrays.copyOfRange(currentIndexed.store, 0, nextIndexed.store.length);
            }
            for (i = 0; i < currentIndexed.store.length; ++i) {
                nextValue = nextIndexed.store[i];
                if (nextValue == null || currentIndexed.store[i] != null) continue;
                if (store == null) {
                    store = Arrays.copyOfRange(currentIndexed.store, 0, currentIndexed.store.length);
                }
                store[i] = nextValue;
            }
            for (i = currentIndexed.store.length; i < nextIndexed.store.length; ++i) {
                nextValue = nextIndexed.store[i];
                if (nextValue == null) continue;
                store[i] = nextValue;
            }
            return store == null ? current : new IndexedContext(store);
        }
        throw new IllegalStateException("Unsupported context type: " + next.getClass().getName());
    }
}

