/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.api.metrics.MeterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.MeterProvider;
import datadog.trace.bootstrap.otel.shim.OtelInstrumentationScope;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeterBuilder;
import datadog.trace.util.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class OtelMeterProvider
implements MeterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelMeterProvider.class);
    private static final String DEFAULT_METER_NAME = "unknown";
    public static final MeterProvider INSTANCE = new OtelMeterProvider();
    private final Map<OtelInstrumentationScope, OtelMeter> meters = new ConcurrentHashMap<OtelInstrumentationScope, OtelMeter>();

    @Override
    public Meter get(String instrumentationScopeName) {
        return this.getMeterShim(instrumentationScopeName, null, null);
    }

    @Override
    public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return new OtelMeterBuilder(this, instrumentationScopeName);
    }

    OtelMeter getMeterShim(String instrumentationScopeName, @Nullable String instrumentationScopeVersion, @Nullable String schemaUrl) {
        if (Strings.isBlank(instrumentationScopeName)) {
            LOGGER.debug("Meter requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_METER_NAME;
        }
        return this.meters.computeIfAbsent(new OtelInstrumentationScope(instrumentationScopeName, instrumentationScopeVersion, schemaUrl), OtelMeter::new);
    }
}

