/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.api;

import datadog.trace.bootstrap.otel.api.DefaultOpenTelemetry;
import datadog.trace.bootstrap.otel.api.logs.LoggerProvider;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.api.metrics.MeterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.MeterProvider;
import datadog.trace.bootstrap.otel.api.trace.Tracer;
import datadog.trace.bootstrap.otel.api.trace.TracerBuilder;
import datadog.trace.bootstrap.otel.api.trace.TracerProvider;
import datadog.trace.bootstrap.otel.context.propagation.ContextPropagators;

public interface OpenTelemetry {
    public static OpenTelemetry noop() {
        return DefaultOpenTelemetry.getNoop();
    }

    public static OpenTelemetry propagating(ContextPropagators propagators) {
        return DefaultOpenTelemetry.getPropagating(propagators);
    }

    public TracerProvider getTracerProvider();

    default public Tracer getTracer(String instrumentationScopeName) {
        return this.getTracerProvider().get(instrumentationScopeName);
    }

    default public Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.getTracerProvider().get(instrumentationScopeName, instrumentationScopeVersion);
    }

    default public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return this.getTracerProvider().tracerBuilder(instrumentationScopeName);
    }

    default public MeterProvider getMeterProvider() {
        return MeterProvider.noop();
    }

    default public Meter getMeter(String instrumentationScopeName) {
        return this.getMeterProvider().get(instrumentationScopeName);
    }

    default public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return this.getMeterProvider().meterBuilder(instrumentationScopeName);
    }

    default public LoggerProvider getLogsBridge() {
        return LoggerProvider.noop();
    }

    public ContextPropagators getPropagators();
}

